package it.auties.whatsapp.model.message.standard;

public class LiveLocationMessageBuilder {
    private double latitude;
    private double longitude;
    private int accuracy;
    private float speed;
    private int magneticNorthOffset;
    private java.util.Optional<java.lang.String> caption;
    private long sequenceNumber;
    private int timeOffset;
    private java.util.Optional<byte[]> thumbnail;
    private java.util.Optional<it.auties.whatsapp.model.info.ContextInfo> contextInfo;

    public LiveLocationMessageBuilder() {
        latitude = 0d;
        longitude = 0d;
        accuracy = 0;
        speed = 0f;
        magneticNorthOffset = 0;
        caption = java.util.Optional.empty();
        sequenceNumber = 0l;
        timeOffset = 0;
        thumbnail = java.util.Optional.empty();
        contextInfo = java.util.Optional.empty();
    }

    public LiveLocationMessageBuilder latitude(double latitude) {
        this.latitude = latitude;
        return this;
    }
    public LiveLocationMessageBuilder longitude(double longitude) {
        this.longitude = longitude;
        return this;
    }
    public LiveLocationMessageBuilder accuracy(int accuracy) {
        this.accuracy = accuracy;
        return this;
    }
    public LiveLocationMessageBuilder speed(float speed) {
        this.speed = speed;
        return this;
    }
    public LiveLocationMessageBuilder magneticNorthOffset(int magneticNorthOffset) {
        this.magneticNorthOffset = magneticNorthOffset;
        return this;
    }
    public LiveLocationMessageBuilder caption(java.util.Optional<java.lang.String> caption) {
        this.caption = caption;
        return this;
    }
    public LiveLocationMessageBuilder caption(java.lang.String caption) {
        this.caption = java.util.Optional.ofNullable(caption);
        return this;
    }
    public LiveLocationMessageBuilder sequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }
    public LiveLocationMessageBuilder timeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
        return this;
    }
    public LiveLocationMessageBuilder thumbnail(java.util.Optional<byte[]> thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }
    public LiveLocationMessageBuilder thumbnail(byte[] thumbnail) {
        this.thumbnail = java.util.Optional.ofNullable(thumbnail);
        return this;
    }
    public LiveLocationMessageBuilder contextInfo(java.util.Optional<it.auties.whatsapp.model.info.ContextInfo> contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }
    public LiveLocationMessageBuilder contextInfo(it.auties.whatsapp.model.info.ContextInfo contextInfo) {
        this.contextInfo = java.util.Optional.ofNullable(contextInfo);
        return this;
    }

    public it.auties.whatsapp.model.message.standard.LiveLocationMessage build() {
        return new it.auties.whatsapp.model.message.standard.LiveLocationMessage(latitude, longitude, accuracy, speed, magneticNorthOffset, caption, sequenceNumber, timeOffset, thumbnail, contextInfo);
    }
}
