package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.LiveLocationMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class LiveLocationMessageSpec {
    public static byte[] encode(LiveLocationMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeDouble(1, protoInputObject.latitude());
outputStream.writeDouble(2, protoInputObject.longitude());
outputStream.writeUInt32(3, protoInputObject.accuracy());
outputStream.writeFloat(4, protoInputObject.speed());
outputStream.writeUInt32(5, protoInputObject.magneticNorthOffset());
var caption = protoInputObject.caption();
var caption0 = caption.orElse(null);
if(caption0 != null) {
outputStream.writeString(6, caption0);
}
outputStream.writeUInt64(7, protoInputObject.sequenceNumber());
outputStream.writeUInt32(8, protoInputObject.timeOffset());
var thumbnail = protoInputObject.thumbnail();
var thumbnail0 = thumbnail.orElse(null);
if(thumbnail0 != null) {
outputStream.writeBytes(16, thumbnail0);
}
var contextInfo = protoInputObject.contextInfo();
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
      return outputStream.toByteArray();
    }

    public static LiveLocationMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        double latitude = 0d;
        double longitude = 0d;
        int accuracy = 0;
        float speed = 0f;
        int magneticNorthOffset = 0;
        java.util.Optional<java.lang.String> caption = java.util.Optional.empty();
        long sequenceNumber = 0l;
        int timeOffset = 0;
        java.util.Optional<byte[]> thumbnail = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.info.ContextInfo> contextInfo = java.util.Optional.empty();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> latitude = inputStream.readDouble();
                case 2 -> longitude = inputStream.readDouble();
                case 3 -> accuracy = inputStream.readInt32();
                case 4 -> speed = inputStream.readFloat();
                case 5 -> magneticNorthOffset = inputStream.readInt32();
                case 6 -> caption = java.util.Optional.ofNullable(inputStream.readString());
                case 7 -> sequenceNumber = inputStream.readInt64();
                case 8 -> timeOffset = inputStream.readInt32();
                case 16 -> thumbnail = java.util.Optional.ofNullable(inputStream.readBytes());
                case 17 -> contextInfo = java.util.Optional.ofNullable(it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.LiveLocationMessage(latitude, longitude, accuracy, speed, magneticNorthOffset, caption, sequenceNumber, timeOffset, thumbnail, contextInfo);
    }

}
