package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.PollUpdateMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PollUpdateMessageSpec {
    public static byte[] encode(PollUpdateMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.message.model.ChatMessageKeySpec.encode(protoInputObject.pollCreationMessageKey()));
var encryptedMetadata = protoInputObject.encryptedMetadata();
if(encryptedMetadata != null) {
var encryptedMetadata0 = encryptedMetadata.orElse(null);
if(encryptedMetadata0 != null) {
outputStream.writeBytes(2, it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadataSpec.encode(encryptedMetadata0));
}
}
var metadata = protoInputObject.metadata();
if(metadata != null) {
var metadata0 = metadata.orElse(null);
if(metadata0 != null) {
outputStream.writeBytes(3, it.auties.whatsapp.model.poll.PollUpdateMessageMetadataSpec.encode(metadata0));
}
}
outputStream.writeInt64(4, protoInputObject.senderTimestampMilliseconds());
      return outputStream.toByteArray();
    }

    public static PollUpdateMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.model.ChatMessageKey pollCreationMessageKey = null;
        it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadata encryptedMetadata = null;
        it.auties.whatsapp.model.poll.PollUpdateMessageMetadata metadata = null;
        long senderTimestampMilliseconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> pollCreationMessageKey = it.auties.whatsapp.model.message.model.ChatMessageKeySpec.decode(inputStream.readBytes());
                case 2 -> encryptedMetadata = it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadataSpec.decode(inputStream.readBytes());
                case 3 -> metadata = it.auties.whatsapp.model.poll.PollUpdateMessageMetadataSpec.decode(inputStream.readBytes());
                case 4 -> senderTimestampMilliseconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.PollUpdateMessage(pollCreationMessageKey, encryptedMetadata, metadata, senderTimestampMilliseconds);
    }

}
