package it.auties.whatsapp.model.message.standard;

public class ProductMessageBuilder {
    private it.auties.whatsapp.model.product.Product product;
    private it.auties.whatsapp.model.jid.Jid businessOwnerJid;
    private it.auties.whatsapp.model.product.ProductCatalog catalog;
    private java.util.Optional<java.lang.String> body;
    private java.util.Optional<java.lang.String> footer;
    private java.util.Optional<it.auties.whatsapp.model.info.ContextInfo> contextInfo;

    public ProductMessageBuilder() {
        product = null;
        businessOwnerJid = null;
        catalog = null;
        body = java.util.Optional.empty();
        footer = java.util.Optional.empty();
        contextInfo = java.util.Optional.empty();
    }

    public ProductMessageBuilder product(it.auties.whatsapp.model.product.Product product) {
        this.product = product;
        return this;
    }
    public ProductMessageBuilder businessOwnerJid(it.auties.whatsapp.model.jid.Jid businessOwnerJid) {
        this.businessOwnerJid = businessOwnerJid;
        return this;
    }
    public ProductMessageBuilder catalog(it.auties.whatsapp.model.product.ProductCatalog catalog) {
        this.catalog = catalog;
        return this;
    }
    public ProductMessageBuilder body(java.util.Optional<java.lang.String> body) {
        this.body = body;
        return this;
    }
    public ProductMessageBuilder body(java.lang.String body) {
        this.body = java.util.Optional.ofNullable(body);
        return this;
    }
    public ProductMessageBuilder footer(java.util.Optional<java.lang.String> footer) {
        this.footer = footer;
        return this;
    }
    public ProductMessageBuilder footer(java.lang.String footer) {
        this.footer = java.util.Optional.ofNullable(footer);
        return this;
    }
    public ProductMessageBuilder contextInfo(java.util.Optional<it.auties.whatsapp.model.info.ContextInfo> contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }
    public ProductMessageBuilder contextInfo(it.auties.whatsapp.model.info.ContextInfo contextInfo) {
        this.contextInfo = java.util.Optional.ofNullable(contextInfo);
        return this;
    }

    public it.auties.whatsapp.model.message.standard.ProductMessage build() {
        return new it.auties.whatsapp.model.message.standard.ProductMessage(product, businessOwnerJid, catalog, body, footer, contextInfo);
    }
}
