package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.ReactionMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ReactionMessageSpec {
    public static byte[] encode(ReactionMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.message.model.ChatMessageKeySpec.encode(protoInputObject.key()));
outputStream.writeString(2, protoInputObject.content());
var groupingKey = protoInputObject.groupingKey();
var groupingKey0 = groupingKey.orElse(null);
if(groupingKey0 != null) {
outputStream.writeString(3, groupingKey0);
}
outputStream.writeInt64(4, protoInputObject.timestampSeconds());
      return outputStream.toByteArray();
    }

    public static ReactionMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.model.ChatMessageKey key = null;
        java.lang.String content = null;
        java.util.Optional<java.lang.String> groupingKey = java.util.Optional.empty();
        long timestampSeconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> key = it.auties.whatsapp.model.message.model.ChatMessageKeySpec.decode(inputStream.readBytes());
                case 2 -> content = inputStream.readString();
                case 3 -> groupingKey = java.util.Optional.ofNullable(inputStream.readString());
                case 4 -> timestampSeconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.ReactionMessage(key, content, groupingKey, timestampSeconds);
    }

}
