package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.VideoOrGifMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class VideoOrGifMessageSpec {
    public static byte[] encode(VideoOrGifMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var mediaUrl = protoInputObject.mediaUrl();
if(mediaUrl != null) {
var mediaUrl0 = mediaUrl.orElse(null);
if(mediaUrl0 != null) {
outputStream.writeString(1, mediaUrl0);
}
}
var mimetype = protoInputObject.mimetype();
if(mimetype != null) {
var mimetype0 = mimetype.orElse(null);
if(mimetype0 != null) {
outputStream.writeString(2, mimetype0);
}
}
var mediaSha256 = protoInputObject.mediaSha256();
if(mediaSha256 != null) {
var mediaSha2560 = mediaSha256.orElse(null);
if(mediaSha2560 != null) {
outputStream.writeBytes(3, mediaSha2560);
}
}
var mediaSize = protoInputObject.mediaSize();
if(mediaSize != null) {
var mediaSize0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaSize);
if(mediaSize0 != null) {
outputStream.writeUInt64(4, mediaSize0);
}
}
var duration = protoInputObject.duration();
if(duration != null) {
var duration0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(duration);
if(duration0 != null) {
outputStream.writeUInt32(5, duration0);
}
}
var mediaKey = protoInputObject.mediaKey();
if(mediaKey != null) {
var mediaKey0 = mediaKey.orElse(null);
if(mediaKey0 != null) {
outputStream.writeBytes(6, mediaKey0);
}
}
var caption = protoInputObject.caption();
if(caption != null) {
var caption0 = caption.orElse(null);
if(caption0 != null) {
outputStream.writeString(7, caption0);
}
}
outputStream.writeBool(8, protoInputObject.gifPlayback());
var height = protoInputObject.height();
if(height != null) {
var height0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(height);
if(height0 != null) {
outputStream.writeUInt32(9, height0);
}
}
var width = protoInputObject.width();
if(width != null) {
var width0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(width);
if(width0 != null) {
outputStream.writeUInt32(10, width0);
}
}
var mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256();
if(mediaEncryptedSha256 != null) {
var mediaEncryptedSha2560 = mediaEncryptedSha256.orElse(null);
if(mediaEncryptedSha2560 != null) {
outputStream.writeBytes(11, mediaEncryptedSha2560);
}
}
      if(protoInputObject.interactiveAnnotations() != null) {
       for(var interactiveAnnotationsEntry : protoInputObject.interactiveAnnotations()) {
outputStream.writeBytes(12, it.auties.whatsapp.model.button.interactive.InteractiveLocationAnnotationSpec.encode(interactiveAnnotationsEntry));
       }
      }
var mediaDirectPath = protoInputObject.mediaDirectPath();
if(mediaDirectPath != null) {
var mediaDirectPath0 = mediaDirectPath.orElse(null);
if(mediaDirectPath0 != null) {
outputStream.writeString(13, mediaDirectPath0);
}
}
var mediaKeyTimestampSeconds = protoInputObject.mediaKeyTimestampSeconds();
var mediaKeyTimestampSeconds0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaKeyTimestampSeconds);
if(mediaKeyTimestampSeconds0 != null) {
outputStream.writeInt64(14, mediaKeyTimestampSeconds0);
}
var thumbnail = protoInputObject.thumbnail();
if(thumbnail != null) {
var thumbnail0 = thumbnail.orElse(null);
if(thumbnail0 != null) {
outputStream.writeBytes(16, thumbnail0);
}
}
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
var streamingSidecar = protoInputObject.streamingSidecar();
if(streamingSidecar != null) {
var streamingSidecar0 = streamingSidecar.orElse(null);
if(streamingSidecar0 != null) {
outputStream.writeBytes(18, streamingSidecar0);
}
}
var gifAttribution = protoInputObject.gifAttribution();
if(gifAttribution != null) {
var gifAttribution0 = gifAttribution.orElse(null);
if(gifAttribution0 != null) {
outputStream.writeInt32(19, it.auties.whatsapp.model.message.standard.VideoOrGifMessageAttributionSpec.encode(gifAttribution0));
}
}
outputStream.writeBool(20, protoInputObject.viewOnce());
var thumbnailDirectPath = protoInputObject.thumbnailDirectPath();
if(thumbnailDirectPath != null) {
var thumbnailDirectPath0 = thumbnailDirectPath.orElse(null);
if(thumbnailDirectPath0 != null) {
outputStream.writeString(21, thumbnailDirectPath0);
}
}
var thumbnailSha256 = protoInputObject.thumbnailSha256();
if(thumbnailSha256 != null) {
var thumbnailSha2560 = thumbnailSha256.orElse(null);
if(thumbnailSha2560 != null) {
outputStream.writeBytes(22, thumbnailSha2560);
}
}
var thumbnailEncSha256 = protoInputObject.thumbnailEncSha256();
if(thumbnailEncSha256 != null) {
var thumbnailEncSha2560 = thumbnailEncSha256.orElse(null);
if(thumbnailEncSha2560 != null) {
outputStream.writeBytes(23, thumbnailEncSha2560);
}
}
var staticUrl = protoInputObject.staticUrl();
if(staticUrl != null) {
var staticUrl0 = staticUrl.orElse(null);
if(staticUrl0 != null) {
outputStream.writeString(24, staticUrl0);
}
}
      return outputStream.toByteArray();
    }

    public static VideoOrGifMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String mediaUrl = null;
        java.lang.String mimetype = null;
        byte[] mediaSha256 = null;
        java.lang.Long mediaSize = null;
        java.lang.Integer duration = null;
        byte[] mediaKey = null;
        java.lang.String caption = null;
        boolean gifPlayback = false;
        java.lang.Integer height = null;
        java.lang.Integer width = null;
        byte[] mediaEncryptedSha256 = null;
        java.util.List<it.auties.whatsapp.model.button.interactive.InteractiveLocationAnnotation> interactiveAnnotations = new java.util.ArrayList<it.auties.whatsapp.model.button.interactive.InteractiveLocationAnnotation>();
        java.lang.String mediaDirectPath = null;
        long mediaKeyTimestampSeconds = 0l;
        byte[] thumbnail = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        byte[] streamingSidecar = null;
        it.auties.whatsapp.model.message.standard.VideoOrGifMessage.Attribution gifAttribution = null;
        boolean viewOnce = false;
        java.lang.String thumbnailDirectPath = null;
        byte[] thumbnailSha256 = null;
        byte[] thumbnailEncSha256 = null;
        java.lang.String staticUrl = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> mediaUrl = inputStream.readString();
                case 2 -> mimetype = inputStream.readString();
                case 3 -> mediaSha256 = inputStream.readBytes();
                case 4 -> mediaSize = inputStream.readInt64();
                case 5 -> duration = inputStream.readInt32();
                case 6 -> mediaKey = inputStream.readBytes();
                case 7 -> caption = inputStream.readString();
                case 8 -> gifPlayback = inputStream.readBool();
                case 9 -> height = inputStream.readInt32();
                case 10 -> width = inputStream.readInt32();
                case 11 -> mediaEncryptedSha256 = inputStream.readBytes();
                case 12 -> interactiveAnnotations.add(it.auties.whatsapp.model.button.interactive.InteractiveLocationAnnotationSpec.decode(inputStream.readBytes()));
                case 13 -> mediaDirectPath = inputStream.readString();
                case 14 -> mediaKeyTimestampSeconds = inputStream.readInt64();
                case 16 -> thumbnail = inputStream.readBytes();
                case 17 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                case 18 -> streamingSidecar = inputStream.readBytes();
                case 19 -> gifAttribution = it.auties.whatsapp.model.message.standard.VideoOrGifMessageAttributionSpec.decode(inputStream.readInt32()).orElse(null);
                case 20 -> viewOnce = inputStream.readBool();
                case 21 -> thumbnailDirectPath = inputStream.readString();
                case 22 -> thumbnailSha256 = inputStream.readBytes();
                case 23 -> thumbnailEncSha256 = inputStream.readBytes();
                case 24 -> staticUrl = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.VideoOrGifMessage(mediaUrl, mimetype, mediaSha256, mediaSize, duration, mediaKey, caption, gifPlayback, height, width, mediaEncryptedSha256, interactiveAnnotations, mediaDirectPath, mediaKeyTimestampSeconds, thumbnail, contextInfo, streamingSidecar, gifAttribution, viewOnce, thumbnailDirectPath, thumbnailSha256, thumbnailEncSha256, staticUrl);
    }

}
