package it.auties.whatsapp.model.payment;

import it.auties.whatsapp.model.payment.PaymentBackground;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PaymentBackgroundSpec {
    public static byte[] encode(PaymentBackground protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.id());
outputStream.writeUInt64(2, protoInputObject.mediaSize());
outputStream.writeUInt32(3, protoInputObject.width());
outputStream.writeUInt32(4, protoInputObject.height());
outputStream.writeString(5, protoInputObject.mimetype());
outputStream.writeFixed32(6, protoInputObject.placeholderArgb());
outputStream.writeFixed32(7, protoInputObject.textArgb());
outputStream.writeFixed32(8, protoInputObject.subtextArgb());
var mediaData = protoInputObject.mediaData();
var mediaData0 = mediaData.orElse(null);
if(mediaData0 != null) {
outputStream.writeBytes(9, it.auties.whatsapp.model.payment.PaymentMediaDataSpec.encode(mediaData0));
}
outputStream.writeInt32(10, it.auties.whatsapp.model.payment.PaymentBackgroundPaymentBackgroundTypeSpec.encode(protoInputObject.type()));
      return outputStream.toByteArray();
    }

    public static PaymentBackground decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String id = null;
        long mediaSize = 0l;
        int width = 0;
        int height = 0;
        java.lang.String mimetype = null;
        int placeholderArgb = 0;
        int textArgb = 0;
        int subtextArgb = 0;
        java.util.Optional<it.auties.whatsapp.model.payment.PaymentMediaData> mediaData = java.util.Optional.empty();
        it.auties.whatsapp.model.payment.PaymentBackground.PaymentBackgroundType type = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readString();
                case 2 -> mediaSize = inputStream.readInt64();
                case 3 -> width = inputStream.readInt32();
                case 4 -> height = inputStream.readInt32();
                case 5 -> mimetype = inputStream.readString();
                case 6 -> placeholderArgb = inputStream.readFixed32();
                case 7 -> textArgb = inputStream.readFixed32();
                case 8 -> subtextArgb = inputStream.readFixed32();
                case 9 -> mediaData = java.util.Optional.ofNullable(it.auties.whatsapp.model.payment.PaymentMediaDataSpec.decode(inputStream.readBytes()));
                case 10 -> type = it.auties.whatsapp.model.payment.PaymentBackgroundPaymentBackgroundTypeSpec.decode(inputStream.readInt32()).orElse(null);
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.payment.PaymentBackground(id, mediaSize, width, height, mimetype, placeholderArgb, textArgb, subtextArgb, mediaData, type);
    }

}
