package it.auties.whatsapp.model.payment;

import it.auties.whatsapp.model.payment.PaymentMediaData;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PaymentMediaDataSpec {
    public static byte[] encode(PaymentMediaData protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.mediaKey());
outputStream.writeInt64(2, protoInputObject.mediaKeyTimestamp());
outputStream.writeBytes(3, protoInputObject.mediaSha256());
outputStream.writeBytes(4, protoInputObject.mediaEncryptedSha256());
outputStream.writeString(5, protoInputObject.mediaDirectPath());
      return outputStream.toByteArray();
    }

    public static PaymentMediaData decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] mediaKey = null;
        long mediaKeyTimestamp = 0l;
        byte[] mediaSha256 = null;
        byte[] mediaEncryptedSha256 = null;
        java.lang.String mediaDirectPath = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> mediaKey = inputStream.readBytes();
                case 2 -> mediaKeyTimestamp = inputStream.readInt64();
                case 3 -> mediaSha256 = inputStream.readBytes();
                case 4 -> mediaEncryptedSha256 = inputStream.readBytes();
                case 5 -> mediaDirectPath = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.payment.PaymentMediaData(mediaKey, mediaKeyTimestamp, mediaSha256, mediaEncryptedSha256, mediaDirectPath);
    }

}
