package it.auties.whatsapp.model.payment;

import it.auties.whatsapp.model.payment.PaymentMoney;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PaymentMoneySpec {
    public static byte[] encode(PaymentMoney protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt64(1, protoInputObject.money());
outputStream.writeUInt32(2, protoInputObject.offset());
outputStream.writeString(3, protoInputObject.currencyCode());
      return outputStream.toByteArray();
    }

    public static PaymentMoney decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        long money = 0l;
        int offset = 0;
        java.lang.String currencyCode = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> money = inputStream.readInt64();
                case 2 -> offset = inputStream.readInt32();
                case 3 -> currencyCode = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.payment.PaymentMoney(money, offset, currencyCode);
    }

}
