package it.auties.whatsapp.model.poll;

import it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadata;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PollUpdateEncryptedMetadataSpec {
    public static byte[] encode(PollUpdateEncryptedMetadata protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.payload());
outputStream.writeBytes(2, protoInputObject.iv());
      return outputStream.toByteArray();
    }

    public static PollUpdateEncryptedMetadata decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] payload = null;
        byte[] iv = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> payload = inputStream.readBytes();
                case 2 -> iv = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadata(payload, iv);
    }

}
