package it.auties.whatsapp.model.product;

import it.auties.whatsapp.model.product.ProductCatalog;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ProductCatalogSpec {
    public static byte[] encode(ProductCatalog protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.message.standard.ImageMessageSpec.encode(protoInputObject.catalogImage()));
outputStream.writeString(2, protoInputObject.title());
outputStream.writeString(3, protoInputObject.description());
      return outputStream.toByteArray();
    }

    public static ProductCatalog decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.standard.ImageMessage catalogImage = null;
        java.lang.String title = null;
        java.lang.String description = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> catalogImage = it.auties.whatsapp.model.message.standard.ImageMessageSpec.decode(inputStream.readBytes());
                case 2 -> title = inputStream.readString();
                case 3 -> description = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.product.ProductCatalog(catalogImage, title, description);
    }

}
