package it.auties.whatsapp.model.setting;

import it.auties.whatsapp.model.setting.AutoDownloadSettings;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class AutoDownloadSettingsSpec {
    public static byte[] encode(AutoDownloadSettings protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.downloadImages());
outputStream.writeBool(2, protoInputObject.downloadAudio());
outputStream.writeBool(3, protoInputObject.downloadVideo());
outputStream.writeBool(4, protoInputObject.downloadDocuments());
      return outputStream.toByteArray();
    }

    public static AutoDownloadSettings decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean downloadImages = false;
        boolean downloadAudio = false;
        boolean downloadVideo = false;
        boolean downloadDocuments = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> downloadImages = inputStream.readBool();
                case 2 -> downloadAudio = inputStream.readBool();
                case 3 -> downloadVideo = inputStream.readBool();
                case 4 -> downloadDocuments = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.setting.AutoDownloadSettings(downloadImages, downloadAudio, downloadVideo, downloadDocuments);
    }

}
