package it.auties.whatsapp.model.setting;

import it.auties.whatsapp.model.setting.AvatarUserSettings;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class AvatarUserSettingsSpec {
    public static byte[] encode(AvatarUserSettings protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.facebookId());
outputStream.writeString(2, protoInputObject.password());
      return outputStream.toByteArray();
    }

    public static AvatarUserSettings decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String facebookId = null;
        java.lang.String password = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> facebookId = inputStream.readString();
                case 2 -> password = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.setting.AvatarUserSettings(facebookId, password);
    }

}
