package it.auties.whatsapp.model.setting;

import it.auties.whatsapp.model.setting.GlobalSettings;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class GlobalSettingsSpec {
    public static byte[] encode(GlobalSettings protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var lightThemeWallpaper = protoInputObject.lightThemeWallpaper();
var lightThemeWallpaper0 = lightThemeWallpaper.orElse(null);
if(lightThemeWallpaper0 != null) {
outputStream.writeBytes(1, it.auties.whatsapp.model.chat.ChatWallpaperSpec.encode(lightThemeWallpaper0));
}
outputStream.writeInt32(2, it.auties.whatsapp.model.media.MediaVisibilitySpec.encode(protoInputObject.mediaVisibility()));
var darkThemeWallpaper = protoInputObject.darkThemeWallpaper();
var darkThemeWallpaper0 = darkThemeWallpaper.orElse(null);
if(darkThemeWallpaper0 != null) {
outputStream.writeBytes(3, it.auties.whatsapp.model.chat.ChatWallpaperSpec.encode(darkThemeWallpaper0));
}
var autoDownloadWiFi = protoInputObject.autoDownloadWiFi();
var autoDownloadWiFi0 = autoDownloadWiFi.orElse(null);
if(autoDownloadWiFi0 != null) {
outputStream.writeBytes(4, it.auties.whatsapp.model.setting.AutoDownloadSettingsSpec.encode(autoDownloadWiFi0));
}
var autoDownloadCellular = protoInputObject.autoDownloadCellular();
var autoDownloadCellular0 = autoDownloadCellular.orElse(null);
if(autoDownloadCellular0 != null) {
outputStream.writeBytes(5, it.auties.whatsapp.model.setting.AutoDownloadSettingsSpec.encode(autoDownloadCellular0));
}
var autoDownloadRoaming = protoInputObject.autoDownloadRoaming();
var autoDownloadRoaming0 = autoDownloadRoaming.orElse(null);
if(autoDownloadRoaming0 != null) {
outputStream.writeBytes(6, it.auties.whatsapp.model.setting.AutoDownloadSettingsSpec.encode(autoDownloadRoaming0));
}
outputStream.writeBool(7, protoInputObject.showIndividualNotificationsPreview());
outputStream.writeBool(8, protoInputObject.showGroupNotificationsPreview());
outputStream.writeInt32(9, protoInputObject.disappearingModeDuration());
outputStream.writeInt64(10, protoInputObject.disappearingModeTimestampSeconds());
outputStream.writeBytes(11, it.auties.whatsapp.model.setting.AvatarUserSettingsSpec.encode(protoInputObject.avatarUserSettings()));
      return outputStream.toByteArray();
    }

    public static GlobalSettings decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.Optional<it.auties.whatsapp.model.chat.ChatWallpaper> lightThemeWallpaper = java.util.Optional.empty();
        it.auties.whatsapp.model.media.MediaVisibility mediaVisibility = null;
        java.util.Optional<it.auties.whatsapp.model.chat.ChatWallpaper> darkThemeWallpaper = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.setting.AutoDownloadSettings> autoDownloadWiFi = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.setting.AutoDownloadSettings> autoDownloadCellular = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.setting.AutoDownloadSettings> autoDownloadRoaming = java.util.Optional.empty();
        boolean showIndividualNotificationsPreview = false;
        boolean showGroupNotificationsPreview = false;
        int disappearingModeDuration = 0;
        long disappearingModeTimestampSeconds = 0l;
        it.auties.whatsapp.model.setting.AvatarUserSettings avatarUserSettings = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> lightThemeWallpaper = java.util.Optional.ofNullable(it.auties.whatsapp.model.chat.ChatWallpaperSpec.decode(inputStream.readBytes()));
                case 2 -> mediaVisibility = it.auties.whatsapp.model.media.MediaVisibilitySpec.decode(inputStream.readInt32()).orElse(null);
                case 3 -> darkThemeWallpaper = java.util.Optional.ofNullable(it.auties.whatsapp.model.chat.ChatWallpaperSpec.decode(inputStream.readBytes()));
                case 4 -> autoDownloadWiFi = java.util.Optional.ofNullable(it.auties.whatsapp.model.setting.AutoDownloadSettingsSpec.decode(inputStream.readBytes()));
                case 5 -> autoDownloadCellular = java.util.Optional.ofNullable(it.auties.whatsapp.model.setting.AutoDownloadSettingsSpec.decode(inputStream.readBytes()));
                case 6 -> autoDownloadRoaming = java.util.Optional.ofNullable(it.auties.whatsapp.model.setting.AutoDownloadSettingsSpec.decode(inputStream.readBytes()));
                case 7 -> showIndividualNotificationsPreview = inputStream.readBool();
                case 8 -> showGroupNotificationsPreview = inputStream.readBool();
                case 9 -> disappearingModeDuration = inputStream.readInt32();
                case 10 -> disappearingModeTimestampSeconds = inputStream.readInt64();
                case 11 -> avatarUserSettings = it.auties.whatsapp.model.setting.AvatarUserSettingsSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.setting.GlobalSettings(lightThemeWallpaper, mediaVisibility, darkThemeWallpaper, autoDownloadWiFi, autoDownloadCellular, autoDownloadRoaming, showIndividualNotificationsPreview, showGroupNotificationsPreview, disappearingModeDuration, disappearingModeTimestampSeconds, avatarUserSettings);
    }

}
