package it.auties.whatsapp.model.setting;

import it.auties.whatsapp.model.setting.LocaleSettings;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class LocaleSettingsSpec {
    public static byte[] encode(LocaleSettings protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.locale());
      return outputStream.toByteArray();
    }

    public static LocaleSettings decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String locale = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> locale = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.setting.LocaleSettings(locale);
    }

}
