package it.auties.whatsapp.model.setting;

import it.auties.whatsapp.model.setting.SecurityNotificationSettings;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SecurityNotificationSettingsSpec {
    public static byte[] encode(SecurityNotificationSettings protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.showNotification());
      return outputStream.toByteArray();
    }

    public static SecurityNotificationSettings decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean showNotification = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> showNotification = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.setting.SecurityNotificationSettings(showNotification);
    }

}
