package it.auties.whatsapp.model.setting;

import it.auties.whatsapp.model.setting.UnarchiveChatsSettings;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class UnarchiveChatsSettingsSpec {
    public static byte[] encode(UnarchiveChatsSettings protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.unarchiveChats());
      return outputStream.toByteArray();
    }

    public static UnarchiveChatsSettings decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean unarchiveChats = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> unarchiveChats = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.setting.UnarchiveChatsSettings(unarchiveChats);
    }

}
