package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.KeyIndexList;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class KeyIndexListSpec {
    public static byte[] encode(KeyIndexList protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt32(1, protoInputObject.rawId());
outputStream.writeUInt64(2, protoInputObject.timestamp());
outputStream.writeUInt32(3, protoInputObject.currentIndex());
      if(protoInputObject.validIndexes() != null) {
       for(var validIndexesEntry : protoInputObject.validIndexes()) {
outputStream.writeUInt32(4, validIndexesEntry);
       }
      }
      return outputStream.toByteArray();
    }

    public static KeyIndexList decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        int rawId = 0;
        long timestamp = 0l;
        int currentIndex = 0;
        java.util.List<java.lang.Integer> validIndexes = new java.util.ArrayList<java.lang.Integer>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> rawId = inputStream.readInt32();
                case 2 -> timestamp = inputStream.readInt64();
                case 3 -> currentIndex = inputStream.readInt32();
                case 4 -> validIndexes.add(inputStream.readInt32());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.KeyIndexList(rawId, timestamp, currentIndex, validIndexes);
    }

}
