package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.NoiseCertificate;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NoiseCertificateSpec {
    public static byte[] encode(NoiseCertificate protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.details());
outputStream.writeBytes(2, protoInputObject.signature());
      return outputStream.toByteArray();
    }

    public static NoiseCertificate decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] details = null;
        byte[] signature = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> details = inputStream.readBytes();
                case 2 -> signature = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.NoiseCertificate(details, signature);
    }

}
