package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.SignedKeyIndexList;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SignedKeyIndexListSpec {
    public static byte[] encode(SignedKeyIndexList protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.details());
outputStream.writeBytes(2, protoInputObject.accountSignature());
      return outputStream.toByteArray();
    }

    public static SignedKeyIndexList decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] details = null;
        byte[] accountSignature = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> details = inputStream.readBytes();
                case 2 -> accountSignature = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.SignedKeyIndexList(details, accountSignature);
    }

}
