package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.WebPayload;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class WebPayloadSpec {
    public static byte[] encode(WebPayload protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.usesParticipantInKey());
outputStream.writeBool(2, protoInputObject.supportsStarredMessages());
outputStream.writeBool(3, protoInputObject.supportsDocumentMessages());
outputStream.writeBool(4, protoInputObject.supportsUrlMessages());
outputStream.writeBool(5, protoInputObject.supportsMediaRetry());
outputStream.writeBool(6, protoInputObject.supportsE2EImage());
outputStream.writeBool(7, protoInputObject.supportsE2EVideo());
outputStream.writeBool(8, protoInputObject.supportsE2EAudio());
outputStream.writeBool(9, protoInputObject.supportsE2EDocument());
outputStream.writeString(10, protoInputObject.documentTypes());
outputStream.writeBytes(11, protoInputObject.features());
      return outputStream.toByteArray();
    }

    public static WebPayload decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean usesParticipantInKey = false;
        boolean supportsStarredMessages = false;
        boolean supportsDocumentMessages = false;
        boolean supportsUrlMessages = false;
        boolean supportsMediaRetry = false;
        boolean supportsE2EImage = false;
        boolean supportsE2EVideo = false;
        boolean supportsE2EAudio = false;
        boolean supportsE2EDocument = false;
        java.lang.String documentTypes = null;
        byte[] features = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> usesParticipantInKey = inputStream.readBool();
                case 2 -> supportsStarredMessages = inputStream.readBool();
                case 3 -> supportsDocumentMessages = inputStream.readBool();
                case 4 -> supportsUrlMessages = inputStream.readBool();
                case 5 -> supportsMediaRetry = inputStream.readBool();
                case 6 -> supportsE2EImage = inputStream.readBool();
                case 7 -> supportsE2EVideo = inputStream.readBool();
                case 8 -> supportsE2EAudio = inputStream.readBool();
                case 9 -> supportsE2EDocument = inputStream.readBool();
                case 10 -> documentTypes = inputStream.readString();
                case 11 -> features = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.WebPayload(usesParticipantInKey, supportsStarredMessages, supportsDocumentMessages, supportsUrlMessages, supportsMediaRetry, supportsE2EImage, supportsE2EVideo, supportsE2EAudio, supportsE2EDocument, documentTypes, features);
    }

}
