package it.auties.whatsapp.model.signal.message;

import it.auties.whatsapp.model.signal.message.SignalDistributionMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SignalDistributionMessageSpec {
    public static byte[] encode(SignalDistributionMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt32(1, protoInputObject.id());
outputStream.writeUInt32(2, protoInputObject.iteration());
outputStream.writeBytes(3, protoInputObject.chainKey());
outputStream.writeBytes(4, protoInputObject.signingKey());
      return outputStream.toByteArray();
    }

    public static SignalDistributionMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.Integer id = null;
        java.lang.Integer iteration = null;
        byte[] chainKey = null;
        byte[] signingKey = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readInt32();
                case 2 -> iteration = inputStream.readInt32();
                case 3 -> chainKey = inputStream.readBytes();
                case 4 -> signingKey = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.message.SignalDistributionMessage(id, iteration, chainKey, signingKey);
    }

}
