package it.auties.whatsapp.model.signal.message;

import it.auties.whatsapp.model.signal.message.SignalMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SignalMessageSpec {
    public static byte[] encode(SignalMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.ephemeralPublicKey());
outputStream.writeUInt32(2, protoInputObject.counter());
outputStream.writeUInt32(3, protoInputObject.previousCounter());
outputStream.writeBytes(4, protoInputObject.ciphertext());
      return outputStream.toByteArray();
    }

    public static SignalMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] ephemeralPublicKey = null;
        java.lang.Integer counter = null;
        java.lang.Integer previousCounter = null;
        byte[] ciphertext = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> ephemeralPublicKey = inputStream.readBytes();
                case 2 -> counter = inputStream.readInt32();
                case 3 -> previousCounter = inputStream.readInt32();
                case 4 -> ciphertext = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.message.SignalMessage(ephemeralPublicKey, counter, previousCounter, ciphertext);
    }

}
