package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.ActionMessageRangeSync;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ActionMessageRangeSyncSpec {
    public static byte[] encode(ActionMessageRangeSync protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt64(1, protoInputObject.lastMessageTimestamp());
outputStream.writeInt64(2, protoInputObject.lastSystemMessageTimestamp());
      if(protoInputObject.messages() != null) {
       for(var messagesEntry : protoInputObject.messages()) {
outputStream.writeBytes(3, it.auties.whatsapp.model.sync.SyncActionMessageSpec.encode(messagesEntry));
       }
      }
      return outputStream.toByteArray();
    }

    public static ActionMessageRangeSync decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.Long lastMessageTimestamp = null;
        java.lang.Long lastSystemMessageTimestamp = null;
        java.util.List<it.auties.whatsapp.model.sync.SyncActionMessage> messages = new java.util.ArrayList<it.auties.whatsapp.model.sync.SyncActionMessage>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> lastMessageTimestamp = inputStream.readInt64();
                case 2 -> lastSystemMessageTimestamp = inputStream.readInt64();
                case 3 -> messages.add(it.auties.whatsapp.model.sync.SyncActionMessageSpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.ActionMessageRangeSync(lastMessageTimestamp, lastSystemMessageTimestamp, messages);
    }

}
