package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.ActionValueSync;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ActionValueSyncSpec {
    public static byte[] encode(ActionValueSync protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt64(1, protoInputObject.timestamp());
var starAction = protoInputObject.starAction();
var starAction0 = starAction.orElse(null);
if(starAction0 != null) {
outputStream.writeBytes(2, it.auties.whatsapp.model.action.StarActionSpec.encode(starAction0));
}
var contactAction = protoInputObject.contactAction();
var contactAction0 = contactAction.orElse(null);
if(contactAction0 != null) {
outputStream.writeBytes(3, it.auties.whatsapp.model.action.ContactActionSpec.encode(contactAction0));
}
var muteAction = protoInputObject.muteAction();
var muteAction0 = muteAction.orElse(null);
if(muteAction0 != null) {
outputStream.writeBytes(4, it.auties.whatsapp.model.action.MuteActionSpec.encode(muteAction0));
}
var pinAction = protoInputObject.pinAction();
var pinAction0 = pinAction.orElse(null);
if(pinAction0 != null) {
outputStream.writeBytes(5, it.auties.whatsapp.model.action.PinActionSpec.encode(pinAction0));
}
var quickReplyAction = protoInputObject.quickReplyAction();
var quickReplyAction0 = quickReplyAction.orElse(null);
if(quickReplyAction0 != null) {
outputStream.writeBytes(8, it.auties.whatsapp.model.action.QuickReplyActionSpec.encode(quickReplyAction0));
}
var recentEmojiWeightsAction = protoInputObject.recentEmojiWeightsAction();
var recentEmojiWeightsAction0 = recentEmojiWeightsAction.orElse(null);
if(recentEmojiWeightsAction0 != null) {
outputStream.writeBytes(11, it.auties.whatsapp.model.action.RecentEmojiWeightsActionSpec.encode(recentEmojiWeightsAction0));
}
var labelEditAction = protoInputObject.labelEditAction();
var labelEditAction0 = labelEditAction.orElse(null);
if(labelEditAction0 != null) {
outputStream.writeBytes(14, it.auties.whatsapp.model.action.LabelEditActionSpec.encode(labelEditAction0));
}
var labelAssociationAction = protoInputObject.labelAssociationAction();
var labelAssociationAction0 = labelAssociationAction.orElse(null);
if(labelAssociationAction0 != null) {
outputStream.writeBytes(15, it.auties.whatsapp.model.action.LabelAssociationActionSpec.encode(labelAssociationAction0));
}
var archiveChatAction = protoInputObject.archiveChatAction();
var archiveChatAction0 = archiveChatAction.orElse(null);
if(archiveChatAction0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.action.ArchiveChatActionSpec.encode(archiveChatAction0));
}
var deleteMessageForMeAction = protoInputObject.deleteMessageForMeAction();
var deleteMessageForMeAction0 = deleteMessageForMeAction.orElse(null);
if(deleteMessageForMeAction0 != null) {
outputStream.writeBytes(18, it.auties.whatsapp.model.action.DeleteMessageForMeActionSpec.encode(deleteMessageForMeAction0));
}
var markChatAsReadAction = protoInputObject.markChatAsReadAction();
var markChatAsReadAction0 = markChatAsReadAction.orElse(null);
if(markChatAsReadAction0 != null) {
outputStream.writeBytes(20, it.auties.whatsapp.model.action.MarkChatAsReadActionSpec.encode(markChatAsReadAction0));
}
var clearChatAction = protoInputObject.clearChatAction();
var clearChatAction0 = clearChatAction.orElse(null);
if(clearChatAction0 != null) {
outputStream.writeBytes(21, it.auties.whatsapp.model.action.ClearChatActionSpec.encode(clearChatAction0));
}
var deleteChatAction = protoInputObject.deleteChatAction();
var deleteChatAction0 = deleteChatAction.orElse(null);
if(deleteChatAction0 != null) {
outputStream.writeBytes(22, it.auties.whatsapp.model.action.DeleteChatActionSpec.encode(deleteChatAction0));
}
var favoriteStickerAction = protoInputObject.favoriteStickerAction();
var favoriteStickerAction0 = favoriteStickerAction.orElse(null);
if(favoriteStickerAction0 != null) {
outputStream.writeBytes(25, it.auties.whatsapp.model.action.StickerActionSpec.encode(favoriteStickerAction0));
}
var androidUnsupportedActions = protoInputObject.androidUnsupportedActions();
var androidUnsupportedActions0 = androidUnsupportedActions.orElse(null);
if(androidUnsupportedActions0 != null) {
outputStream.writeBytes(26, it.auties.whatsapp.model.action.AndroidUnsupportedActionsSpec.encode(androidUnsupportedActions0));
}
var agentAction = protoInputObject.agentAction();
var agentAction0 = agentAction.orElse(null);
if(agentAction0 != null) {
outputStream.writeBytes(27, it.auties.whatsapp.model.action.AgentActionSpec.encode(agentAction0));
}
var subscriptionAction = protoInputObject.subscriptionAction();
var subscriptionAction0 = subscriptionAction.orElse(null);
if(subscriptionAction0 != null) {
outputStream.writeBytes(28, it.auties.whatsapp.model.action.SubscriptionActionSpec.encode(subscriptionAction0));
}
var userStatusMuteAction = protoInputObject.userStatusMuteAction();
var userStatusMuteAction0 = userStatusMuteAction.orElse(null);
if(userStatusMuteAction0 != null) {
outputStream.writeBytes(29, it.auties.whatsapp.model.action.UserStatusMuteActionSpec.encode(userStatusMuteAction0));
}
var timeFormatAction = protoInputObject.timeFormatAction();
var timeFormatAction0 = timeFormatAction.orElse(null);
if(timeFormatAction0 != null) {
outputStream.writeBytes(30, it.auties.whatsapp.model.action.TimeFormatActionSpec.encode(timeFormatAction0));
}
var nuxAction = protoInputObject.nuxAction();
var nuxAction0 = nuxAction.orElse(null);
if(nuxAction0 != null) {
outputStream.writeBytes(31, it.auties.whatsapp.model.action.NuxActionSpec.encode(nuxAction0));
}
var primaryVersionAction = protoInputObject.primaryVersionAction();
var primaryVersionAction0 = primaryVersionAction.orElse(null);
if(primaryVersionAction0 != null) {
outputStream.writeBytes(32, it.auties.whatsapp.model.action.PrimaryVersionActionSpec.encode(primaryVersionAction0));
}
var stickerAction = protoInputObject.stickerAction();
var stickerAction0 = stickerAction.orElse(null);
if(stickerAction0 != null) {
outputStream.writeBytes(33, it.auties.whatsapp.model.action.StickerActionSpec.encode(stickerAction0));
}
var removeRecentStickerAction = protoInputObject.removeRecentStickerAction();
var removeRecentStickerAction0 = removeRecentStickerAction.orElse(null);
if(removeRecentStickerAction0 != null) {
outputStream.writeBytes(34, it.auties.whatsapp.model.action.RemoveRecentStickerActionSpec.encode(removeRecentStickerAction0));
}
var chatAssignmentAction = protoInputObject.chatAssignmentAction();
var chatAssignmentAction0 = chatAssignmentAction.orElse(null);
if(chatAssignmentAction0 != null) {
outputStream.writeBytes(35, it.auties.whatsapp.model.action.ChatAssignmentActionSpec.encode(chatAssignmentAction0));
}
var chatAssignmentOpenedStatusAction = protoInputObject.chatAssignmentOpenedStatusAction();
var chatAssignmentOpenedStatusAction0 = chatAssignmentOpenedStatusAction.orElse(null);
if(chatAssignmentOpenedStatusAction0 != null) {
outputStream.writeBytes(36, it.auties.whatsapp.model.action.ChatAssignmentOpenedStatusActionSpec.encode(chatAssignmentOpenedStatusAction0));
}
var securityNotificationSetting = protoInputObject.securityNotificationSetting();
var securityNotificationSetting0 = securityNotificationSetting.orElse(null);
if(securityNotificationSetting0 != null) {
outputStream.writeBytes(6, it.auties.whatsapp.model.setting.SecurityNotificationSettingsSpec.encode(securityNotificationSetting0));
}
var pushNameSetting = protoInputObject.pushNameSetting();
var pushNameSetting0 = pushNameSetting.orElse(null);
if(pushNameSetting0 != null) {
outputStream.writeBytes(7, it.auties.whatsapp.model.setting.PushNameSettingsSpec.encode(pushNameSetting0));
}
var localeSetting = protoInputObject.localeSetting();
var localeSetting0 = localeSetting.orElse(null);
if(localeSetting0 != null) {
outputStream.writeBytes(16, it.auties.whatsapp.model.setting.LocaleSettingsSpec.encode(localeSetting0));
}
var unarchiveChatsSetting = protoInputObject.unarchiveChatsSetting();
var unarchiveChatsSetting0 = unarchiveChatsSetting.orElse(null);
if(unarchiveChatsSetting0 != null) {
outputStream.writeBytes(23, it.auties.whatsapp.model.setting.UnarchiveChatsSettingsSpec.encode(unarchiveChatsSetting0));
}
var stickerMetadata = protoInputObject.stickerMetadata();
var stickerMetadata0 = stickerMetadata.orElse(null);
if(stickerMetadata0 != null) {
outputStream.writeBytes(10, it.auties.whatsapp.model.sync.StickerMetadataSpec.encode(stickerMetadata0));
}
var keyExpiration = protoInputObject.keyExpiration();
var keyExpiration0 = keyExpiration.orElse(null);
if(keyExpiration0 != null) {
outputStream.writeBytes(19, it.auties.whatsapp.model.sync.KeyExpirationSpec.encode(keyExpiration0));
}
var primaryFeature = protoInputObject.primaryFeature();
var primaryFeature0 = primaryFeature.orElse(null);
if(primaryFeature0 != null) {
outputStream.writeBytes(24, it.auties.whatsapp.model.sync.PrimaryFeatureSpec.encode(primaryFeature0));
}
      return outputStream.toByteArray();
    }

    public static ActionValueSync decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        long timestamp = 0l;
        java.util.Optional<it.auties.whatsapp.model.action.StarAction> starAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.ContactAction> contactAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.MuteAction> muteAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.PinAction> pinAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.QuickReplyAction> quickReplyAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.RecentEmojiWeightsAction> recentEmojiWeightsAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.LabelEditAction> labelEditAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.LabelAssociationAction> labelAssociationAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.ArchiveChatAction> archiveChatAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.DeleteMessageForMeAction> deleteMessageForMeAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.MarkChatAsReadAction> markChatAsReadAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.ClearChatAction> clearChatAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.DeleteChatAction> deleteChatAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.StickerAction> favoriteStickerAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.AndroidUnsupportedActions> androidUnsupportedActions = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.AgentAction> agentAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.SubscriptionAction> subscriptionAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.UserStatusMuteAction> userStatusMuteAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.TimeFormatAction> timeFormatAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.NuxAction> nuxAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.PrimaryVersionAction> primaryVersionAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.StickerAction> stickerAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.RemoveRecentStickerAction> removeRecentStickerAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.ChatAssignmentAction> chatAssignmentAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.action.ChatAssignmentOpenedStatusAction> chatAssignmentOpenedStatusAction = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.setting.SecurityNotificationSettings> securityNotificationSetting = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.setting.PushNameSettings> pushNameSetting = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.setting.LocaleSettings> localeSetting = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.setting.UnarchiveChatsSettings> unarchiveChatsSetting = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.sync.StickerMetadata> stickerMetadata = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.sync.KeyExpiration> keyExpiration = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.sync.PrimaryFeature> primaryFeature = java.util.Optional.empty();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> timestamp = inputStream.readInt64();
                case 2 -> starAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.StarActionSpec.decode(inputStream.readBytes()));
                case 3 -> contactAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.ContactActionSpec.decode(inputStream.readBytes()));
                case 4 -> muteAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.MuteActionSpec.decode(inputStream.readBytes()));
                case 5 -> pinAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.PinActionSpec.decode(inputStream.readBytes()));
                case 8 -> quickReplyAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.QuickReplyActionSpec.decode(inputStream.readBytes()));
                case 11 -> recentEmojiWeightsAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.RecentEmojiWeightsActionSpec.decode(inputStream.readBytes()));
                case 14 -> labelEditAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.LabelEditActionSpec.decode(inputStream.readBytes()));
                case 15 -> labelAssociationAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.LabelAssociationActionSpec.decode(inputStream.readBytes()));
                case 17 -> archiveChatAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.ArchiveChatActionSpec.decode(inputStream.readBytes()));
                case 18 -> deleteMessageForMeAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.DeleteMessageForMeActionSpec.decode(inputStream.readBytes()));
                case 20 -> markChatAsReadAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.MarkChatAsReadActionSpec.decode(inputStream.readBytes()));
                case 21 -> clearChatAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.ClearChatActionSpec.decode(inputStream.readBytes()));
                case 22 -> deleteChatAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.DeleteChatActionSpec.decode(inputStream.readBytes()));
                case 25 -> favoriteStickerAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.StickerActionSpec.decode(inputStream.readBytes()));
                case 26 -> androidUnsupportedActions = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.AndroidUnsupportedActionsSpec.decode(inputStream.readBytes()));
                case 27 -> agentAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.AgentActionSpec.decode(inputStream.readBytes()));
                case 28 -> subscriptionAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.SubscriptionActionSpec.decode(inputStream.readBytes()));
                case 29 -> userStatusMuteAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.UserStatusMuteActionSpec.decode(inputStream.readBytes()));
                case 30 -> timeFormatAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.TimeFormatActionSpec.decode(inputStream.readBytes()));
                case 31 -> nuxAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.NuxActionSpec.decode(inputStream.readBytes()));
                case 32 -> primaryVersionAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.PrimaryVersionActionSpec.decode(inputStream.readBytes()));
                case 33 -> stickerAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.StickerActionSpec.decode(inputStream.readBytes()));
                case 34 -> removeRecentStickerAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.RemoveRecentStickerActionSpec.decode(inputStream.readBytes()));
                case 35 -> chatAssignmentAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.ChatAssignmentActionSpec.decode(inputStream.readBytes()));
                case 36 -> chatAssignmentOpenedStatusAction = java.util.Optional.ofNullable(it.auties.whatsapp.model.action.ChatAssignmentOpenedStatusActionSpec.decode(inputStream.readBytes()));
                case 6 -> securityNotificationSetting = java.util.Optional.ofNullable(it.auties.whatsapp.model.setting.SecurityNotificationSettingsSpec.decode(inputStream.readBytes()));
                case 7 -> pushNameSetting = java.util.Optional.ofNullable(it.auties.whatsapp.model.setting.PushNameSettingsSpec.decode(inputStream.readBytes()));
                case 16 -> localeSetting = java.util.Optional.ofNullable(it.auties.whatsapp.model.setting.LocaleSettingsSpec.decode(inputStream.readBytes()));
                case 23 -> unarchiveChatsSetting = java.util.Optional.ofNullable(it.auties.whatsapp.model.setting.UnarchiveChatsSettingsSpec.decode(inputStream.readBytes()));
                case 10 -> stickerMetadata = java.util.Optional.ofNullable(it.auties.whatsapp.model.sync.StickerMetadataSpec.decode(inputStream.readBytes()));
                case 19 -> keyExpiration = java.util.Optional.ofNullable(it.auties.whatsapp.model.sync.KeyExpirationSpec.decode(inputStream.readBytes()));
                case 24 -> primaryFeature = java.util.Optional.ofNullable(it.auties.whatsapp.model.sync.PrimaryFeatureSpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.ActionValueSync(timestamp, starAction, contactAction, muteAction, pinAction, quickReplyAction, recentEmojiWeightsAction, labelEditAction, labelAssociationAction, archiveChatAction, deleteMessageForMeAction, markChatAsReadAction, clearChatAction, deleteChatAction, favoriteStickerAction, androidUnsupportedActions, agentAction, subscriptionAction, userStatusMuteAction, timeFormatAction, nuxAction, primaryVersionAction, stickerAction, removeRecentStickerAction, chatAssignmentAction, chatAssignmentOpenedStatusAction, securityNotificationSetting, pushNameSetting, localeSetting, unarchiveChatsSetting, stickerMetadata, keyExpiration, primaryFeature);
    }

}
