package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.AppStateSyncKeyData;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class AppStateSyncKeyDataSpec {
    public static byte[] encode(AppStateSyncKeyData protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.keyData());
outputStream.writeBytes(2, it.auties.whatsapp.model.sync.AppStateSyncKeyFingerprintSpec.encode(protoInputObject.fingerprint()));
outputStream.writeInt64(3, protoInputObject.timestamp());
      return outputStream.toByteArray();
    }

    public static AppStateSyncKeyData decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] keyData = null;
        it.auties.whatsapp.model.sync.AppStateSyncKeyFingerprint fingerprint = null;
        java.lang.Long timestamp = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> keyData = inputStream.readBytes();
                case 2 -> fingerprint = it.auties.whatsapp.model.sync.AppStateSyncKeyFingerprintSpec.decode(inputStream.readBytes());
                case 3 -> timestamp = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.AppStateSyncKeyData(keyData, fingerprint, timestamp);
    }

}
