package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.AppStateSyncKeyId;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class AppStateSyncKeyIdSpec {
    public static byte[] encode(AppStateSyncKeyId protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.keyId());
      return outputStream.toByteArray();
    }

    public static AppStateSyncKeyId decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] keyId = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> keyId = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.AppStateSyncKeyId(keyId);
    }

}
