package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.AppStateSyncKeyRequest;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class AppStateSyncKeyRequestSpec {
    public static byte[] encode(AppStateSyncKeyRequest protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
      if(protoInputObject.keyIds() != null) {
       for(var keyIdsEntry : protoInputObject.keyIds()) {
outputStream.writeBytes(1, it.auties.whatsapp.model.sync.AppStateSyncKeyIdSpec.encode(keyIdsEntry));
       }
      }
      return outputStream.toByteArray();
    }

    public static AppStateSyncKeyRequest decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.List<it.auties.whatsapp.model.sync.AppStateSyncKeyId> keyIds = new java.util.ArrayList<it.auties.whatsapp.model.sync.AppStateSyncKeyId>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> keyIds.add(it.auties.whatsapp.model.sync.AppStateSyncKeyIdSpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.AppStateSyncKeyRequest(keyIds);
    }

}
