package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.AppStateSyncKey;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class AppStateSyncKeySpec {
    public static byte[] encode(AppStateSyncKey protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.sync.AppStateSyncKeyIdSpec.encode(protoInputObject.keyId()));
outputStream.writeBytes(2, it.auties.whatsapp.model.sync.AppStateSyncKeyDataSpec.encode(protoInputObject.keyData()));
      return outputStream.toByteArray();
    }

    public static AppStateSyncKey decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.sync.AppStateSyncKeyId keyId = null;
        it.auties.whatsapp.model.sync.AppStateSyncKeyData keyData = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> keyId = it.auties.whatsapp.model.sync.AppStateSyncKeyIdSpec.decode(inputStream.readBytes());
                case 2 -> keyData = it.auties.whatsapp.model.sync.AppStateSyncKeyDataSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.AppStateSyncKey(keyId, keyData);
    }

}
