package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.DeviceListMetadata;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class DeviceListMetadataSpec {
    public static byte[] encode(DeviceListMetadata protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.senderKeyHash());
outputStream.writeUInt64(2, protoInputObject.senderTimestamp());
      if(protoInputObject.senderKeyIndexes() != null) {
       for(var senderKeyIndexesEntry : protoInputObject.senderKeyIndexes()) {
outputStream.writeUInt32(3, senderKeyIndexesEntry);
       }
      }
outputStream.writeBytes(8, protoInputObject.recipientKeyHash());
outputStream.writeUInt64(9, protoInputObject.recipientTimestamp());
      if(protoInputObject.recipientKeyIndexes() != null) {
       for(var recipientKeyIndexesEntry : protoInputObject.recipientKeyIndexes()) {
outputStream.writeUInt32(10, recipientKeyIndexesEntry);
       }
      }
      return outputStream.toByteArray();
    }

    public static DeviceListMetadata decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] senderKeyHash = null;
        java.lang.Long senderTimestamp = null;
        java.util.List<java.lang.Integer> senderKeyIndexes = new java.util.ArrayList<java.lang.Integer>();
        byte[] recipientKeyHash = null;
        java.lang.Long recipientTimestamp = null;
        java.util.List<java.lang.Integer> recipientKeyIndexes = new java.util.ArrayList<java.lang.Integer>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> senderKeyHash = inputStream.readBytes();
                case 2 -> senderTimestamp = inputStream.readInt64();
                case 3 -> senderKeyIndexes.addAll(inputStream.readInt32Packed());
                case 8 -> recipientKeyHash = inputStream.readBytes();
                case 9 -> recipientTimestamp = inputStream.readInt64();
                case 10 -> recipientKeyIndexes.addAll(inputStream.readInt32Packed());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.DeviceListMetadata(senderKeyHash, senderTimestamp, senderKeyIndexes, recipientKeyHash, recipientTimestamp, recipientKeyIndexes);
    }

}
