package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.ExitCode;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ExitCodeSpec {
    public static byte[] encode(ExitCode protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt64(1, protoInputObject.code());
outputStream.writeString(2, protoInputObject.text());
      return outputStream.toByteArray();
    }

    public static ExitCode decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        long code = 0l;
        java.lang.String text = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> code = inputStream.readInt64();
                case 2 -> text = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.ExitCode(code, text);
    }

}
