package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.ExternalBlobReference;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ExternalBlobReferenceSpec {
    public static byte[] encode(ExternalBlobReference protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var mediaKey = protoInputObject.mediaKey();
if(mediaKey != null) {
var mediaKey0 = mediaKey.orElse(null);
if(mediaKey0 != null) {
outputStream.writeBytes(1, mediaKey0);
}
}
var mediaDirectPath = protoInputObject.mediaDirectPath();
if(mediaDirectPath != null) {
var mediaDirectPath0 = mediaDirectPath.orElse(null);
if(mediaDirectPath0 != null) {
outputStream.writeString(2, mediaDirectPath0);
}
}
var handle = protoInputObject.handle();
if(handle != null) {
var handle0 = handle.orElse(null);
if(handle0 != null) {
outputStream.writeString(3, handle0);
}
}
var mediaSize = protoInputObject.mediaSize();
var mediaSize0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaSize);
if(mediaSize0 != null) {
outputStream.writeUInt64(4, mediaSize0);
}
var mediaSha256 = protoInputObject.mediaSha256();
if(mediaSha256 != null) {
var mediaSha2560 = mediaSha256.orElse(null);
if(mediaSha2560 != null) {
outputStream.writeBytes(5, mediaSha2560);
}
}
var mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256();
if(mediaEncryptedSha256 != null) {
var mediaEncryptedSha2560 = mediaEncryptedSha256.orElse(null);
if(mediaEncryptedSha2560 != null) {
outputStream.writeBytes(6, mediaEncryptedSha2560);
}
}
      return outputStream.toByteArray();
    }

    public static ExternalBlobReference decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] mediaKey = null;
        java.lang.String mediaDirectPath = null;
        java.lang.String handle = null;
        long mediaSize = 0l;
        byte[] mediaSha256 = null;
        byte[] mediaEncryptedSha256 = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> mediaKey = inputStream.readBytes();
                case 2 -> mediaDirectPath = inputStream.readString();
                case 3 -> handle = inputStream.readString();
                case 4 -> mediaSize = inputStream.readInt64();
                case 5 -> mediaSha256 = inputStream.readBytes();
                case 6 -> mediaEncryptedSha256 = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.ExternalBlobReference(mediaKey, mediaDirectPath, handle, mediaSize, mediaSha256, mediaEncryptedSha256);
    }

}
