package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.HistorySync;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import java.util.Objects;

public class HistorySyncSpec {
    public static byte[] encode(HistorySync protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      Objects.requireNonNull(protoInputObject.syncType(), "Missing required property: syncType");
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, it.auties.whatsapp.model.sync.HistorySyncTypeSpec.encode(protoInputObject.syncType()));
      if(protoInputObject.conversations() != null) {
       for(var conversationsEntry : protoInputObject.conversations()) {
outputStream.writeBytes(2, it.auties.whatsapp.model.chat.ChatSpec.encode(conversationsEntry));
       }
      }
      if(protoInputObject.statusV3Messages() != null) {
       for(var statusV3MessagesEntry : protoInputObject.statusV3Messages()) {
outputStream.writeBytes(3, it.auties.whatsapp.model.info.ChatMessageInfoSpec.encode(statusV3MessagesEntry));
       }
      }
outputStream.writeUInt32(5, protoInputObject.chunkOrder());
outputStream.writeUInt32(6, protoInputObject.progress());
      if(protoInputObject.pushNames() != null) {
       for(var pushNamesEntry : protoInputObject.pushNames()) {
outputStream.writeBytes(7, it.auties.whatsapp.model.sync.PushNameSpec.encode(pushNamesEntry));
       }
      }
outputStream.writeBytes(8, it.auties.whatsapp.model.setting.GlobalSettingsSpec.encode(protoInputObject.globalSettings()));
outputStream.writeBytes(9, protoInputObject.threadIdUserSecret());
outputStream.writeUInt32(10, protoInputObject.threadDsTimeframeOffset());
      if(protoInputObject.recentStickers() != null) {
       for(var recentStickersEntry : protoInputObject.recentStickers()) {
outputStream.writeBytes(11, it.auties.whatsapp.model.sync.StickerMetadataSpec.encode(recentStickersEntry));
       }
      }
      if(protoInputObject.pastParticipants() != null) {
       for(var pastParticipantsEntry : protoInputObject.pastParticipants()) {
outputStream.writeBytes(12, it.auties.whatsapp.model.chat.GroupPastParticipantsSpec.encode(pastParticipantsEntry));
       }
      }
      return outputStream.toByteArray();
    }

    public static HistorySync decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.sync.HistorySync.Type syncType = null;
        java.util.List<it.auties.whatsapp.model.chat.Chat> conversations = new java.util.ArrayList<it.auties.whatsapp.model.chat.Chat>();
        java.util.List<it.auties.whatsapp.model.info.ChatMessageInfo> statusV3Messages = new java.util.ArrayList<it.auties.whatsapp.model.info.ChatMessageInfo>();
        int chunkOrder = 0;
        java.lang.Integer progress = null;
        java.util.List<it.auties.whatsapp.model.sync.PushName> pushNames = new java.util.ArrayList<it.auties.whatsapp.model.sync.PushName>();
        it.auties.whatsapp.model.setting.GlobalSettings globalSettings = null;
        byte[] threadIdUserSecret = null;
        int threadDsTimeframeOffset = 0;
        java.util.List<it.auties.whatsapp.model.sync.StickerMetadata> recentStickers = new java.util.ArrayList<it.auties.whatsapp.model.sync.StickerMetadata>();
        java.util.List<it.auties.whatsapp.model.chat.GroupPastParticipants> pastParticipants = new java.util.ArrayList<it.auties.whatsapp.model.chat.GroupPastParticipants>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> syncType = it.auties.whatsapp.model.sync.HistorySyncTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 2 -> conversations.add(it.auties.whatsapp.model.chat.ChatSpec.decode(inputStream.readBytes()));
                case 3 -> statusV3Messages.add(it.auties.whatsapp.model.info.ChatMessageInfoSpec.decode(inputStream.readBytes()));
                case 5 -> chunkOrder = inputStream.readInt32();
                case 6 -> progress = inputStream.readInt32();
                case 7 -> pushNames.add(it.auties.whatsapp.model.sync.PushNameSpec.decode(inputStream.readBytes()));
                case 8 -> globalSettings = it.auties.whatsapp.model.setting.GlobalSettingsSpec.decode(inputStream.readBytes());
                case 9 -> threadIdUserSecret = inputStream.readBytes();
                case 10 -> threadDsTimeframeOffset = inputStream.readInt32();
                case 11 -> recentStickers.add(it.auties.whatsapp.model.sync.StickerMetadataSpec.decode(inputStream.readBytes()));
                case 12 -> pastParticipants.add(it.auties.whatsapp.model.chat.GroupPastParticipantsSpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        Objects.requireNonNull(syncType, "Missing required property: syncType");
        return new it.auties.whatsapp.model.sync.HistorySync(syncType, conversations, statusV3Messages, chunkOrder, progress, pushNames, globalSettings, threadIdUserSecret, threadDsTimeframeOffset, recentStickers, pastParticipants);
    }

}
