package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.PhotoChange;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PhotoChangeSpec {
    public static byte[] encode(PhotoChange protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.oldPhoto());
outputStream.writeBytes(2, protoInputObject.newPhoto());
outputStream.writeUInt32(3, protoInputObject.newPhotoId());
      return outputStream.toByteArray();
    }

    public static PhotoChange decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] oldPhoto = null;
        byte[] newPhoto = null;
        java.lang.Integer newPhotoId = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> oldPhoto = inputStream.readBytes();
                case 2 -> newPhoto = inputStream.readBytes();
                case 3 -> newPhotoId = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.PhotoChange(oldPhoto, newPhoto, newPhotoId);
    }

}
