package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.RecentEmojiWeight;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class RecentEmojiWeightSpec {
    public static byte[] encode(RecentEmojiWeight protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.emoji());
outputStream.writeFloat(2, protoInputObject.weight());
      return outputStream.toByteArray();
    }

    public static RecentEmojiWeight decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String emoji = null;
        java.lang.Float weight = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> emoji = inputStream.readString();
                case 2 -> weight = inputStream.readFloat();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.RecentEmojiWeight(emoji, weight);
    }

}
