package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.RecordSync;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class RecordSyncSpec {
    public static byte[] encode(RecordSync protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.sync.IndexSyncSpec.encode(protoInputObject.index()));
outputStream.writeBytes(2, it.auties.whatsapp.model.sync.ValueSyncSpec.encode(protoInputObject.value()));
outputStream.writeBytes(3, it.auties.whatsapp.model.sync.KeyIdSpec.encode(protoInputObject.keyId()));
      return outputStream.toByteArray();
    }

    public static RecordSync decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.sync.IndexSync index = null;
        it.auties.whatsapp.model.sync.ValueSync value = null;
        it.auties.whatsapp.model.sync.KeyId keyId = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> index = it.auties.whatsapp.model.sync.IndexSyncSpec.decode(inputStream.readBytes());
                case 2 -> value = it.auties.whatsapp.model.sync.ValueSyncSpec.decode(inputStream.readBytes());
                case 3 -> keyId = it.auties.whatsapp.model.sync.KeyIdSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.RecordSync(index, value, keyId);
    }

}
