package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.StickerMetadata;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class StickerMetadataSpec {
    public static byte[] encode(StickerMetadata protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.url());
outputStream.writeBytes(2, protoInputObject.fileSha256());
outputStream.writeBytes(3, protoInputObject.fileEncSha256());
outputStream.writeBytes(4, protoInputObject.mediaKey());
outputStream.writeString(5, protoInputObject.mimetype());
outputStream.writeUInt32(6, protoInputObject.height());
outputStream.writeUInt32(7, protoInputObject.width());
outputStream.writeString(8, protoInputObject.directPath());
outputStream.writeUInt64(9, protoInputObject.fileLength());
outputStream.writeFloat(10, protoInputObject.weight());
outputStream.writeInt64(11, protoInputObject.lastStickerSentTs());
      return outputStream.toByteArray();
    }

    public static StickerMetadata decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String url = null;
        byte[] fileSha256 = null;
        byte[] fileEncSha256 = null;
        byte[] mediaKey = null;
        java.lang.String mimetype = null;
        int height = 0;
        int width = 0;
        java.lang.String directPath = null;
        long fileLength = 0l;
        float weight = 0f;
        long lastStickerSentTs = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> url = inputStream.readString();
                case 2 -> fileSha256 = inputStream.readBytes();
                case 3 -> fileEncSha256 = inputStream.readBytes();
                case 4 -> mediaKey = inputStream.readBytes();
                case 5 -> mimetype = inputStream.readString();
                case 6 -> height = inputStream.readInt32();
                case 7 -> width = inputStream.readInt32();
                case 8 -> directPath = inputStream.readString();
                case 9 -> fileLength = inputStream.readInt64();
                case 10 -> weight = inputStream.readFloat();
                case 11 -> lastStickerSentTs = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.StickerMetadata(url, fileSha256, fileEncSha256, mediaKey, mimetype, height, width, directPath, fileLength, weight, lastStickerSentTs);
    }

}
