package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.ValueSync;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ValueSyncSpec {
    public static byte[] encode(ValueSync protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.blob());
      return outputStream.toByteArray();
    }

    public static ValueSync decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] blob = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> blob = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.ValueSync(blob);
    }

}
