/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.AsyncVerificationCodeSupplier;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.mobile.VerificationCodeMethod;
import it.auties.whatsapp.registration.HttpRegistration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public sealed class MobileRegistrationBuilder<T extends MobileRegistrationBuilder<T>> {
    final Store store;
    final Keys keys;
    final ErrorHandler errorHandler;
    final ExecutorService socketExecutor;
    Whatsapp whatsapp;
    AsyncVerificationCodeSupplier verificationCodeSupplier;

    MobileRegistrationBuilder(Store store, Keys keys, ErrorHandler errorHandler, ExecutorService socketExecutor) {
        this.store = store;
        this.keys = keys;
        this.errorHandler = errorHandler;
        this.socketExecutor = socketExecutor;
    }

    public T verificationCodeSupplier(Supplier<String> verificationCodeSupplier) {
        this.verificationCodeSupplier = AsyncVerificationCodeSupplier.of(verificationCodeSupplier);
        return (T)this;
    }

    public T verificationCodeSupplier(AsyncVerificationCodeSupplier verificationCodeSupplier) {
        this.verificationCodeSupplier = verificationCodeSupplier;
        return (T)this;
    }

    Whatsapp buildWhatsapp() {
        this.whatsapp = Whatsapp.customBuilder().store(this.store).keys(this.keys).errorHandler(this.errorHandler).socketExecutor(this.socketExecutor).build();
        return this.whatsapp;
    }

    public static final class Unverified
    extends MobileRegistrationBuilder<Unverified> {
        Unverified(Store store, Keys keys, ErrorHandler errorHandler, ExecutorService socketExecutor) {
            super(store, keys, errorHandler, socketExecutor);
        }

        public CompletableFuture<Whatsapp> verify(long phoneNumber) {
            PhoneNumber number = PhoneNumber.of(phoneNumber);
            this.keys.setPhoneNumber(number);
            this.store.setPhoneNumber(number);
            return this.verify();
        }

        public CompletableFuture<Whatsapp> verify() {
            Objects.requireNonNull(this.store.phoneNumber(), "Missing phone number: please specify it");
            Objects.requireNonNull(this.verificationCodeSupplier, "Expected a valid verification code supplier");
            HttpRegistration registration = new HttpRegistration(this.store, this.keys, this.verificationCodeSupplier, VerificationCodeMethod.NONE);
            return registration.sendVerificationCode().thenApply(ignored -> this.buildWhatsapp());
        }
    }

    public static final class Unregistered
    extends MobileRegistrationBuilder<Unregistered> {
        private Unverified unverified;
        private VerificationCodeMethod verificationCodeMethod = VerificationCodeMethod.SMS;

        Unregistered(Store store, Keys keys, ErrorHandler errorHandler, ExecutorService socketExecutor) {
            super(store, keys, errorHandler, socketExecutor);
        }

        public Unregistered verificationCodeMethod(VerificationCodeMethod verificationCodeMethod) {
            this.verificationCodeMethod = verificationCodeMethod;
            return this;
        }

        public CompletableFuture<Whatsapp> register(long phoneNumber) {
            if (this.whatsapp != null) {
                return CompletableFuture.completedFuture(this.whatsapp);
            }
            Objects.requireNonNull(this.verificationCodeSupplier, "Expected a valid verification code supplier");
            Objects.requireNonNull(this.verificationCodeMethod, "Expected a valid verification method");
            if (!this.keys.registered()) {
                PhoneNumber number = PhoneNumber.of(phoneNumber);
                this.keys.setPhoneNumber(number);
                this.store.setPhoneNumber(number);
                HttpRegistration registration = new HttpRegistration(this.store, this.keys, this.verificationCodeSupplier, this.verificationCodeMethod);
                return registration.registerPhoneNumber().thenApply(ignored -> this.buildWhatsapp());
            }
            return CompletableFuture.completedFuture(this.buildWhatsapp());
        }

        public CompletableFuture<Unverified> requestVerificationCode(long phoneNumber) {
            if (this.unverified != null) {
                return CompletableFuture.completedFuture(this.unverified);
            }
            PhoneNumber number = PhoneNumber.of(phoneNumber);
            this.keys.setPhoneNumber(number);
            this.store.setPhoneNumber(number);
            if (!this.keys.registered()) {
                HttpRegistration registration = new HttpRegistration(this.store, this.keys, this.verificationCodeSupplier, this.verificationCodeMethod);
                return registration.requestVerificationCode().thenApply(ignored -> {
                    this.unverified = new Unverified(this.store, this.keys, this.errorHandler, this.socketExecutor);
                    return this.unverified;
                });
            }
            this.unverified = new Unverified(this.store, this.keys, this.errorHandler, this.socketExecutor);
            return CompletableFuture.completedFuture(this.unverified);
        }
    }
}

