/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.controller.Controller;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.model.companion.CompanionHashState;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentity;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalPreKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPair;
import it.auties.whatsapp.model.signal.sender.SenderKeyName;
import it.auties.whatsapp.model.signal.sender.SenderKeyRecord;
import it.auties.whatsapp.model.signal.session.Session;
import it.auties.whatsapp.model.signal.session.SessionAddress;
import it.auties.whatsapp.model.sync.AppStateSyncKey;
import it.auties.whatsapp.model.sync.PatchType;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Keys
extends Controller<Keys> {
    private final int registrationId;
    private final SignalKeyPair noiseKeyPair;
    private final SignalKeyPair ephemeralKeyPair;
    private final SignalKeyPair identityKeyPair;
    private SignalKeyPair companionKeyPair;
    private final SignalSignedKeyPair signedKeyPair;
    private byte[] signedKeyIndex;
    private Long signedKeyIndexTimestamp;
    private final List<SignalPreKeyPair> preKeys;
    private final String phoneId;
    private final byte[] deviceId;
    private final byte[] identityId;
    private SignedDeviceIdentity companionIdentity;
    private final Map<SenderKeyName, SenderKeyRecord> senderKeys;
    private final Map<Jid, LinkedList<AppStateSyncKey>> appStateKeys;
    private final Map<SessionAddress, Session> sessions;
    private final Map<Jid, Map<PatchType, CompanionHashState>> hashStates;
    private final Map<Jid, Collection<Jid>> groupsPreKeys;
    private boolean registered;
    private boolean businessCertificate;
    private boolean initialAppSync;
    @JsonIgnore
    private final AtomicLong writeCounter;
    @JsonIgnore
    private final AtomicLong readCounter;
    @JsonIgnore
    private byte[] writeKey;
    @JsonIgnore
    private byte[] readKey;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Keys(UUID uuid, PhoneNumber phoneNumber, ControllerSerializer serializer, ClientType clientType, Collection<String> alias, int registrationId, SignalKeyPair noiseKeyPair, SignalKeyPair ephemeralKeyPair, SignalKeyPair identityKeyPair, SignalKeyPair companionKeyPair, SignalSignedKeyPair signedKeyPair, byte[] signedKeyIndex, Long signedKeyIndexTimestamp, List<SignalPreKeyPair> preKeys, String phoneId, byte[] deviceId, byte[] identityId, SignedDeviceIdentity companionIdentity, Map<SenderKeyName, SenderKeyRecord> senderKeys, Map<Jid, LinkedList<AppStateSyncKey>> appStateKeys, Map<SessionAddress, Session> sessions, Map<Jid, Map<PatchType, CompanionHashState>> hashStates, Map<Jid, Collection<Jid>> groupsPreKeys, boolean registered, boolean businessCertificate, boolean initialAppSync) {
        super(uuid, phoneNumber, serializer, clientType, alias);
        this.registrationId = registrationId;
        this.noiseKeyPair = noiseKeyPair;
        this.ephemeralKeyPair = ephemeralKeyPair;
        this.identityKeyPair = identityKeyPair;
        this.companionKeyPair = companionKeyPair;
        this.signedKeyPair = signedKeyPair;
        this.signedKeyIndex = signedKeyIndex;
        this.signedKeyIndexTimestamp = signedKeyIndexTimestamp;
        this.preKeys = preKeys;
        this.phoneId = phoneId;
        this.deviceId = deviceId;
        this.identityId = identityId;
        this.companionIdentity = companionIdentity;
        this.senderKeys = senderKeys;
        this.appStateKeys = appStateKeys;
        this.sessions = sessions;
        this.hashStates = hashStates;
        this.groupsPreKeys = groupsPreKeys;
        this.registered = registered;
        this.businessCertificate = businessCertificate;
        this.initialAppSync = initialAppSync;
        this.writeCounter = new AtomicLong();
        this.readCounter = new AtomicLong();
    }

    public byte[] encodedRegistrationId() {
        return BytesHelper.intToBytes(this.registrationId(), 4);
    }

    public void clearReadWriteKey() {
        this.writeKey = null;
        this.writeCounter.set(0L);
        this.readCounter.set(0L);
    }

    public boolean hasPreKeys() {
        return !this.preKeys.isEmpty();
    }

    public SenderKeyRecord findSenderKeyByName(SenderKeyName name) {
        return Objects.requireNonNullElseGet(this.senderKeys.get(name), () -> {
            SenderKeyRecord record = new SenderKeyRecord();
            this.senderKeys.put(name, record);
            return record;
        });
    }

    public Optional<Session> findSessionByAddress(SessionAddress address) {
        return Optional.ofNullable(this.sessions.get(address));
    }

    public Optional<SignalSignedKeyPair> findSignedKeyPairById(int id) {
        return id == this.signedKeyPair.id() ? Optional.of(this.signedKeyPair) : Optional.empty();
    }

    public Optional<SignalPreKeyPair> findPreKeyById(Integer id) {
        return id == null ? Optional.empty() : this.preKeys.stream().filter(preKey -> preKey.id() == id.intValue()).findFirst();
    }

    public Optional<AppStateSyncKey> findAppKeyById(Jid jid, byte[] id) {
        return Objects.requireNonNull(this.appStateKeys.get(jid), "Missing keys").stream().filter(preKey -> preKey.keyId() != null && Arrays.equals(preKey.keyId().keyId(), id)).findFirst();
    }

    public Optional<CompanionHashState> findHashStateByName(Jid device, PatchType patchType) {
        return Optional.ofNullable(this.hashStates.get(device)).map(entry -> (CompanionHashState)entry.get((Object)patchType));
    }

    public boolean hasTrust(SessionAddress address, byte[] identityKey) {
        return true;
    }

    public boolean hasSession(SessionAddress address) {
        return this.sessions.containsKey(address);
    }

    public Keys putSession(SessionAddress address, Session record) {
        this.sessions.put(address, record);
        return this;
    }

    public Keys putState(Jid device, CompanionHashState state) {
        Map oldData = Objects.requireNonNullElseGet(this.hashStates.get(device), HashMap::new);
        oldData.put(state.name(), state);
        this.hashStates.put(device, oldData);
        return this;
    }

    public Keys addAppKeys(Jid jid, Collection<AppStateSyncKey> keys) {
        this.appStateKeys.put(jid, new LinkedList<AppStateSyncKey>(keys));
        return this;
    }

    public AppStateSyncKey getLatestAppKey(Jid jid) {
        LinkedList<AppStateSyncKey> keys = Objects.requireNonNull(this.appStateKeys.get(jid), "Missing keys");
        return keys.getLast();
    }

    public LinkedList<AppStateSyncKey> getAppKeys(Jid jid) {
        return Objects.requireNonNullElseGet(this.appStateKeys.get(jid), LinkedList::new);
    }

    public Keys addPreKey(SignalPreKeyPair preKey) {
        this.preKeys.add(preKey);
        return this;
    }

    public long writeCounter(boolean increment) {
        return increment ? this.writeCounter.getAndIncrement() : this.writeCounter.get();
    }

    public long readCounter(boolean increment) {
        return increment ? this.readCounter.getAndIncrement() : this.readCounter.get();
    }

    public int lastPreKeyId() {
        return this.preKeys.isEmpty() ? 0 : this.preKeys.getLast().id();
    }

    public Keys companionIdentity(SignedDeviceIdentity companionIdentity) {
        this.companionIdentity = companionIdentity;
        return this;
    }

    public Optional<SignedDeviceIdentity> companionIdentity() {
        return Optional.ofNullable(this.companionIdentity);
    }

    public Collection<SignalPreKeyPair> preKeys() {
        return Collections.unmodifiableList(this.preKeys);
    }

    public void addRecipientWithPreKeys(Jid group, Jid recipient) {
        Collection<Jid> preKeys = this.groupsPreKeys.get(group);
        if (preKeys != null) {
            preKeys.add(recipient);
            return;
        }
        ArrayList<Jid> newPreKeys = new ArrayList<Jid>();
        newPreKeys.add(recipient);
        this.groupsPreKeys.put(group, newPreKeys);
    }

    public void addRecipientsWithPreKeys(Jid group, Collection<Jid> recipients) {
        Collection<Jid> preKeys = this.groupsPreKeys.get(group);
        if (preKeys != null) {
            preKeys.addAll(recipients);
            return;
        }
        ArrayList<Jid> newPreKeys = new ArrayList<Jid>(recipients);
        this.groupsPreKeys.put(group, newPreKeys);
    }

    public boolean hasGroupKeys(Jid group, Jid recipient) {
        Collection<Jid> preKeys = this.groupsPreKeys.get(group);
        return preKeys != null && preKeys.contains(recipient);
    }

    @Override
    public void dispose() {
        this.serialize(false);
    }

    @Override
    public void serialize(boolean async) {
        this.serializer.serializeKeys(this, async);
    }

    public int registrationId() {
        return this.registrationId;
    }

    public SignalKeyPair noiseKeyPair() {
        return this.noiseKeyPair;
    }

    public SignalKeyPair ephemeralKeyPair() {
        return this.ephemeralKeyPair;
    }

    public SignalKeyPair identityKeyPair() {
        return this.identityKeyPair;
    }

    public SignalSignedKeyPair signedKeyPair() {
        return this.signedKeyPair;
    }

    public Optional<byte[]> signedKeyIndex() {
        return Optional.ofNullable(this.signedKeyIndex);
    }

    public OptionalLong signedKeyIndexTimestamp() {
        return Clock.parseTimestamp(this.signedKeyIndexTimestamp);
    }

    public SignalKeyPair companionKeyPair() {
        return this.companionKeyPair;
    }

    public String phoneId() {
        return this.phoneId;
    }

    public byte[] deviceId() {
        return this.deviceId;
    }

    public byte[] identityId() {
        return this.identityId;
    }

    public Map<SenderKeyName, SenderKeyRecord> senderKeys() {
        return this.senderKeys;
    }

    public Map<Jid, LinkedList<AppStateSyncKey>> appStateKeys() {
        return this.appStateKeys;
    }

    public Map<SessionAddress, Session> sessions() {
        return this.sessions;
    }

    public Map<Jid, Map<PatchType, CompanionHashState>> hashStates() {
        return this.hashStates;
    }

    public Map<Jid, Collection<Jid>> groupsPreKeys() {
        return this.groupsPreKeys;
    }

    public boolean registered() {
        return this.registered;
    }

    public boolean businessCertificate() {
        return this.businessCertificate;
    }

    public boolean initialAppSync() {
        return this.initialAppSync;
    }

    public AtomicLong writeCounter() {
        return this.writeCounter;
    }

    public AtomicLong readCounter() {
        return this.readCounter;
    }

    public Optional<byte[]> writeKey() {
        return Optional.ofNullable(this.writeKey);
    }

    public Optional<byte[]> readKey() {
        return Optional.ofNullable(this.readKey);
    }

    public Keys setCompanionKeyPair(SignalKeyPair companionKeyPair) {
        this.companionKeyPair = companionKeyPair;
        return this;
    }

    public Keys setSignedKeyIndex(byte[] signedKeyIndex) {
        this.signedKeyIndex = signedKeyIndex;
        return this;
    }

    public Keys setSignedKeyIndexTimestamp(Long signedKeyIndexTimestamp) {
        this.signedKeyIndexTimestamp = signedKeyIndexTimestamp;
        return this;
    }

    public Keys setCompanionIdentity(SignedDeviceIdentity companionIdentity) {
        this.companionIdentity = companionIdentity;
        return this;
    }

    public Keys setRegistered(boolean registered) {
        this.registered = registered;
        return this;
    }

    public Keys setBusinessCertificate(boolean businessCertificate) {
        this.businessCertificate = businessCertificate;
        return this;
    }

    public Keys setInitialAppSync(boolean initialAppSync) {
        this.initialAppSync = initialAppSync;
        return this;
    }

    public Keys setWriteKey(byte[] writeKey) {
        this.writeKey = writeKey;
        return this;
    }

    public Keys setReadKey(byte[] readKey) {
        this.readKey = readKey;
        return this;
    }

    public String toString() {
        String cryptographicKeys = Stream.of(this.noiseKeyPair.publicKey(), this.noiseKeyPair.privateKey(), this.identityKeyPair.publicKey(), this.identityKeyPair.privateKey(), this.identityId()).map(Base64.getEncoder()::encodeToString).collect(Collectors.joining(","));
        return this.phoneNumber().map(phoneNumber -> String.valueOf(phoneNumber) + "," + cryptographicKeys).orElse(cryptographicKeys);
    }
}

