/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.TextPreviewSetting;
import it.auties.whatsapp.api.WebHistoryLength;
import it.auties.whatsapp.controller.Controller;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.listener.Listener;
import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.call.Call;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatBuilder;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.companion.CompanionDevice;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.MessageStatusInfo;
import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.jid.JidServer;
import it.auties.whatsapp.model.media.MediaConnection;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.mobile.CountryLocale;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.newsletter.NewsletterName;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.whatsapp.model.privacy.PrivacySettingType;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.whatsapp.registration.TokenProvider;
import it.auties.whatsapp.socket.SocketRequest;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.FutureReference;
import it.auties.whatsapp.util.ProxyAuthenticator;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HexFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Store
extends Controller<Store> {
    private URI proxy;
    private FutureReference<Version> version;
    private boolean online;
    private CountryLocale locale;
    private String name;
    private String businessAddress;
    private Double businessLongitude;
    private Double businessLatitude;
    private String businessDescription;
    private String businessWebsite;
    private String businessEmail;
    private BusinessCategory businessCategory;
    private String deviceHash;
    private LinkedHashMap<Jid, Integer> linkedDevicesKeys;
    private URI profilePicture;
    private String about;
    private Jid jid;
    private Jid lid;
    private final ConcurrentHashMap<String, String> properties;
    @JsonIgnore
    private final ConcurrentHashMap<Jid, Chat> chats;
    private final ConcurrentHashMap<Jid, Contact> contacts;
    private final ConcurrentHashMap<Jid, ConcurrentHashMap<String, ChatMessageInfo>> status;
    private final ConcurrentHashMap<Jid, Newsletter> newsletters;
    private final ConcurrentHashMap<PrivacySettingType, PrivacySettingEntry> privacySettings;
    private final ConcurrentHashMap<String, Call> calls;
    private boolean unarchiveChats;
    private boolean twentyFourHourFormat;
    @JsonIgnore
    private final ConcurrentHashMap<String, SocketRequest> requests;
    @JsonIgnore
    private final ConcurrentHashMap<String, CompletableFuture<ChatMessageInfo>> replyHandlers;
    @JsonIgnore
    private final ConcurrentHashMap.KeySetView<Listener, Boolean> listeners;
    @JsonIgnore
    private final String tag;
    private final long initializationTimeStamp;
    @JsonIgnore
    private MediaConnection mediaConnection;
    @JsonIgnore
    private final CountDownLatch mediaConnectionLatch;
    private ChatEphemeralTimer newChatsEphemeralTimer;
    private TextPreviewSetting textPreviewSetting;
    private WebHistoryLength historyLength;
    private boolean autodetectListeners;
    private boolean cacheDetectedListeners;
    private boolean automaticPresenceUpdates;
    private UserAgent.ReleaseChannel releaseChannel;
    private CompanionDevice device;
    private boolean checkPatchMacs;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Store(UUID uuid, PhoneNumber phoneNumber, ControllerSerializer serializer, ClientType clientType, Collection<String> alias, URI proxy, FutureReference<Version> version, boolean online, CountryLocale locale, String name, String businessAddress, Double businessLongitude, Double businessLatitude, String businessDescription, String businessWebsite, String businessEmail, BusinessCategory businessCategory, String deviceHash, LinkedHashMap<Jid, Integer> linkedDevicesKeys, URI profilePicture, String about, Jid jid, Jid lid, ConcurrentHashMap<String, String> properties, ConcurrentHashMap<Jid, Contact> contacts, ConcurrentHashMap<Jid, ConcurrentHashMap<String, ChatMessageInfo>> status, ConcurrentHashMap<Jid, Newsletter> newsletters, ConcurrentHashMap<PrivacySettingType, PrivacySettingEntry> privacySettings, ConcurrentHashMap<String, Call> calls, boolean unarchiveChats, boolean twentyFourHourFormat, long initializationTimeStamp, ChatEphemeralTimer newChatsEphemeralTimer, TextPreviewSetting textPreviewSetting, WebHistoryLength historyLength, boolean autodetectListeners, boolean cacheDetectedListeners, boolean automaticPresenceUpdates, UserAgent.ReleaseChannel releaseChannel, CompanionDevice device, boolean checkPatchMacs) {
        super(uuid, phoneNumber, serializer, clientType, alias);
        if (proxy != null) {
            ProxyAuthenticator.register(proxy);
        }
        this.proxy = proxy;
        this.version = version;
        this.online = online;
        this.locale = locale;
        this.name = name;
        this.businessAddress = businessAddress;
        this.businessLongitude = businessLongitude;
        this.businessLatitude = businessLatitude;
        this.businessDescription = businessDescription;
        this.businessWebsite = businessWebsite;
        this.businessEmail = businessEmail;
        this.businessCategory = businessCategory;
        this.deviceHash = deviceHash;
        this.linkedDevicesKeys = linkedDevicesKeys;
        this.profilePicture = profilePicture;
        this.about = about;
        this.jid = jid;
        this.lid = lid;
        this.properties = properties;
        this.chats = new ConcurrentHashMap();
        this.contacts = contacts;
        this.status = status;
        this.newsletters = newsletters;
        this.privacySettings = privacySettings;
        this.calls = calls;
        this.unarchiveChats = unarchiveChats;
        this.twentyFourHourFormat = twentyFourHourFormat;
        this.requests = new ConcurrentHashMap();
        this.replyHandlers = new ConcurrentHashMap();
        this.listeners = ConcurrentHashMap.newKeySet();
        this.tag = HexFormat.of().formatHex(BytesHelper.random(1));
        this.initializationTimeStamp = initializationTimeStamp;
        this.mediaConnectionLatch = new CountDownLatch(1);
        this.newChatsEphemeralTimer = newChatsEphemeralTimer;
        this.textPreviewSetting = textPreviewSetting;
        this.historyLength = historyLength;
        this.autodetectListeners = autodetectListeners;
        this.cacheDetectedListeners = cacheDetectedListeners;
        this.automaticPresenceUpdates = automaticPresenceUpdates;
        this.releaseChannel = releaseChannel;
        this.device = device;
        this.checkPatchMacs = checkPatchMacs;
    }

    public Optional<Contact> findContactByJid(JidProvider jid) {
        if (jid == null) {
            return Optional.empty();
        }
        if (jid instanceof Contact) {
            Contact contact = (Contact)jid;
            return Optional.of(contact);
        }
        return Optional.ofNullable(this.contacts.get(jid.toJid()));
    }

    public Optional<Contact> findContactByName(String name) {
        return this.findContactsStream(name).findAny();
    }

    private Stream<Contact> findContactsStream(String name) {
        return name == null ? Stream.empty() : this.contacts().parallelStream().filter(contact -> {
            if (contact.fullName().filter(name::equals).isPresent()) return true;
            if (contact.chosenName().filter(name::equals).isPresent()) return true;
            if (!contact.shortName().filter(name::equals).isPresent()) return false;
            return true;
        });
    }

    public Collection<Contact> contacts() {
        return Collections.unmodifiableCollection(this.contacts.values());
    }

    public Set<Contact> findContactsByName(String name) {
        return this.findContactsStream(name).collect(Collectors.toUnmodifiableSet());
    }

    public Optional<ChatMessageInfo> findMessageByKey(ChatMessageKey key) {
        return Optional.ofNullable(key).map(ChatMessageKey::chatJid).flatMap(this::findChatByJid).flatMap(chat -> this.findMessageById((Chat)chat, key.id()));
    }

    public Optional<? extends MessageStatusInfo<?>> findMessageById(JidProvider provider, String id) {
        if (provider == null || id == null) {
            return Optional.empty();
        }
        JidProvider jidProvider = provider;
        Objects.requireNonNull(jidProvider);
        JidProvider jidProvider2 = jidProvider;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Chat.class, Newsletter.class, Contact.class, Jid.class}, (Object)jidProvider2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Chat chat = (Chat)jidProvider2;
                yield this.findMessageById(chat, id);
            }
            case 1 -> {
                Newsletter newsletter = (Newsletter)jidProvider2;
                yield this.findMessageById(newsletter, id);
            }
            case 2 -> {
                Contact contact = (Contact)jidProvider2;
                yield this.findChatByJid(contact.jid()).flatMap(chat -> this.findMessageById((Chat)chat, id));
            }
            case 3 -> {
                Jid contactJid = (Jid)jidProvider2;
                switch (contactJid.type()) {
                    case NEWSLETTER: {
                        yield this.findNewsletterByJid(contactJid).flatMap(newsletter -> this.findMessageById((Newsletter)newsletter, id));
                    }
                    case STATUS: {
                        ConcurrentHashMap<String, ChatMessageInfo> messages = this.status.get(contactJid);
                        if (messages == null) {
                            yield Optional.empty();
                        }
                        yield Optional.ofNullable(messages.get(id));
                    }
                }
                yield this.findChatByJid(contactJid).flatMap(chat -> this.findMessageById((Chat)chat, id));
            }
        };
    }

    public Optional<NewsletterMessageInfo> findMessageById(Newsletter newsletter, String id) {
        return newsletter.messages().parallelStream().filter(entry -> Objects.equals(id, entry.id()) || Objects.equals(id, String.valueOf(entry.serverId()))).findFirst();
    }

    public Optional<ChatMessageInfo> findMessageById(Chat chat, String id) {
        return chat.messages().parallelStream().map(HistorySyncMessage::messageInfo).filter(message -> Objects.equals(message.key().id(), id)).findAny();
    }

    public Optional<Chat> findChatByJid(JidProvider jid) {
        if (jid == null) {
            return Optional.empty();
        }
        if (jid instanceof Chat) {
            Chat chat = (Chat)jid;
            return Optional.of(chat);
        }
        return Optional.ofNullable(this.chats.get(jid.toJid()));
    }

    public Optional<Newsletter> findNewsletterByJid(JidProvider jid) {
        if (jid == null) {
            return Optional.empty();
        }
        if (jid instanceof Newsletter) {
            Newsletter newsletter = (Newsletter)jid;
            return Optional.of(newsletter);
        }
        return Optional.ofNullable(this.newsletters.get(jid.toJid()));
    }

    public Optional<Chat> findChatByName(String name) {
        return this.findChatsByNameStream(name).findAny();
    }

    public Optional<Newsletter> findNewsletterByName(String name) {
        return this.findNewslettersByNameStream(name).findAny();
    }

    private Stream<Chat> findChatsByNameStream(String name) {
        return name == null ? Stream.empty() : this.chats.values().parallelStream().filter(chat -> chat.name().equalsIgnoreCase(name));
    }

    private Stream<Newsletter> findNewslettersByNameStream(String name) {
        return name == null ? Stream.empty() : this.newsletters.values().parallelStream().filter(newsletter -> name.equalsIgnoreCase(newsletter.metadata().name().map(NewsletterName::text).orElse(null)));
    }

    public Optional<Chat> findChatBy(Function<Chat, Boolean> function) {
        return this.chats.values().parallelStream().filter(function::apply).findFirst();
    }

    public Optional<Newsletter> findNewsletterBy(Function<Newsletter, Boolean> function) {
        return this.newsletters.values().parallelStream().filter(function::apply).findFirst();
    }

    public Set<Chat> findChatsByName(String name) {
        return this.findChatsByNameStream(name).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Newsletter> findNewslettersByName(String name) {
        return this.findNewslettersByNameStream(name).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Chat> findChatsBy(Function<Chat, Boolean> function) {
        return this.chats.values().stream().filter(function::apply).collect(Collectors.toUnmodifiableSet());
    }

    public Collection<ChatMessageInfo> status() {
        return this.status.values().stream().flatMap(entry -> entry.values().stream()).collect(Collectors.toUnmodifiableSet());
    }

    public Collection<Newsletter> newsletters() {
        return Collections.unmodifiableCollection(this.newsletters.values());
    }

    public Collection<ChatMessageInfo> findStatusBySender(JidProvider jid) {
        return Optional.ofNullable(this.status.get(jid.toJid())).map(entry -> Collections.unmodifiableCollection(entry.values())).orElseGet(Set::of);
    }

    public boolean resolvePendingRequest(Node response, boolean exceptionally) {
        return this.findPendingRequest(response.id()).map(request -> this.deleteAndComplete((SocketRequest)request, response, exceptionally)).isPresent();
    }

    public Optional<SocketRequest> findPendingRequest(String id) {
        return id == null ? Optional.empty() : Optional.ofNullable(this.requests.get(id));
    }

    private SocketRequest deleteAndComplete(SocketRequest request, Node response, boolean exceptionally) {
        if (request.complete(response, exceptionally)) {
            this.requests.remove(request.id());
        }
        return request;
    }

    public void resolveAllPendingRequests() {
        this.requests.values().forEach(request -> request.complete(null, false));
    }

    public Collection<SocketRequest> pendingRequests() {
        return Collections.unmodifiableCollection(this.requests.values());
    }

    public boolean resolvePendingReply(ChatMessageInfo response) {
        return response.message().contentWithContext().flatMap(ContextualMessage::contextInfo).flatMap(ContextInfo::quotedMessageId).map(id -> {
            CompletableFuture<ChatMessageInfo> future = this.replyHandlers.remove(id);
            if (future == null) {
                return false;
            }
            future.complete(response);
            return true;
        }).orElse(false);
    }

    public Chat addNewChat(Jid chatJid) {
        Chat chat = new ChatBuilder().jid(chatJid).build();
        this.addChat(chat);
        return chat;
    }

    public Optional<Chat> addChat(Chat chat) {
        Chat oldChat;
        if (chat.hasName() && chat.jid().hasServer(JidServer.WHATSAPP)) {
            Contact contact = this.findContactByJid(chat.jid()).orElseGet(() -> this.addContact(new Contact(chat.jid())));
            contact.setFullName(chat.name());
        }
        if ((oldChat = this.chats.get(chat.jid())) != null) {
            if (oldChat.hasName() && !chat.hasName()) {
                chat.setName(oldChat.name());
            }
            this.joinMessages(chat, oldChat);
        }
        return this.addChatDirect(chat);
    }

    private void joinMessages(Chat chat, Chat oldChat) {
        Long newChatTimestamp = chat.newestMessage().map(message -> message.timestampSeconds().orElse(0L)).orElse(0L);
        Long oldChatTimestamp = oldChat.newestMessage().map(message -> message.timestampSeconds().orElse(0L)).orElse(0L);
        if (newChatTimestamp <= oldChatTimestamp) {
            chat.addMessages(oldChat.messages());
            return;
        }
        chat.addOldMessages(chat.messages());
    }

    public Optional<Chat> addChatDirect(Chat chat) {
        return Optional.ofNullable(this.chats.put(chat.jid(), chat));
    }

    public Contact addContact(Jid jid) {
        return this.addContact(new Contact(jid));
    }

    public Contact addContact(Contact contact) {
        this.contacts.put(contact.jid(), contact);
        return contact;
    }

    public Optional<Newsletter> addNewsletter(Newsletter newsletter) {
        return Optional.ofNullable(this.newsletters.put(newsletter.jid(), newsletter));
    }

    public Optional<Chat> removeChat(JidProvider chatJid) {
        return Optional.ofNullable(this.chats.remove(chatJid.toJid()));
    }

    public Optional<Newsletter> removeNewsletter(JidProvider newsletterJid) {
        return Optional.ofNullable(this.newsletters.remove(newsletterJid.toJid()));
    }

    public Optional<Contact> removeContact(JidProvider contactJid) {
        return Optional.ofNullable(this.contacts.remove(contactJid.toJid()));
    }

    public List<Chat> pinnedChats() {
        return this.chats.values().parallelStream().filter(Chat::isPinned).sorted(Comparator.comparingLong(Chat::pinnedTimestampSeconds).reversed()).toList();
    }

    public List<ChatMessageInfo> starredMessages() {
        return this.chats().parallelStream().map(Chat::starredMessages).flatMap(Collection::stream).toList();
    }

    public List<Chat> chats() {
        return this.chats.values().stream().sorted(Comparator.comparingLong(Chat::timestampSeconds).reversed()).toList();
    }

    public Map<String, String> properties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void addProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    public MediaConnection mediaConnection() {
        return this.mediaConnection(Duration.ofMinutes(1L));
    }

    public MediaConnection mediaConnection(Duration timeout) {
        try {
            boolean result = this.mediaConnectionLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (!result) {
                throw new RuntimeException("Cannot get media connection");
            }
            return this.mediaConnection;
        }
        catch (InterruptedException exception) {
            throw new RuntimeException("Cannot lock on media connection", exception);
        }
    }

    public Store setMediaConnection(MediaConnection mediaConnection) {
        this.mediaConnection = mediaConnection;
        this.mediaConnectionLatch.countDown();
        return this;
    }

    public Collection<Contact> blockedContacts() {
        return this.contacts().stream().filter(Contact::blocked).toList();
    }

    public Store addStatus(ChatMessageInfo info) {
        ConcurrentHashMap wrapper = Objects.requireNonNullElseGet(this.status.get(info.senderJid()), ConcurrentHashMap::new);
        wrapper.put(info.id(), info);
        this.status.put(info.senderJid(), wrapper);
        return this;
    }

    public CompletableFuture<Node> addRequest(SocketRequest request) {
        if (request.id() == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.requests.put(request.id(), request);
        return request.future();
    }

    public CompletableFuture<ChatMessageInfo> addPendingReply(String messageId) {
        CompletableFuture<ChatMessageInfo> result = new CompletableFuture<ChatMessageInfo>();
        this.replyHandlers.put(messageId, result);
        return result;
    }

    public Optional<URI> profilePicture() {
        return Optional.ofNullable(this.profilePicture);
    }

    public Collection<PrivacySettingEntry> privacySettings() {
        return this.privacySettings.values();
    }

    public PrivacySettingEntry findPrivacySetting(PrivacySettingType type) {
        return this.privacySettings.get((Object)type);
    }

    public PrivacySettingEntry addPrivacySetting(PrivacySettingType type, PrivacySettingEntry entry) {
        return this.privacySettings.put(type, entry);
    }

    public Map<Jid, Integer> linkedDevicesKeys() {
        return Collections.unmodifiableMap(this.linkedDevicesKeys);
    }

    public Collection<Jid> linkedDevices() {
        return Collections.unmodifiableCollection(this.linkedDevicesKeys.keySet());
    }

    public Optional<Integer> addLinkedDevice(Jid companion, int keyId) {
        return Optional.ofNullable(this.linkedDevicesKeys.put(companion, keyId));
    }

    public Optional<Integer> removeLinkedCompanion(Jid companion) {
        return Optional.ofNullable((Integer)this.linkedDevicesKeys.remove(companion));
    }

    public void removeLinkedCompanions() {
        this.linkedDevicesKeys.clear();
    }

    public Collection<Listener> listeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public Store addListener(Listener listener) {
        this.listeners.add(listener);
        return this;
    }

    public Store addListeners(Collection<Listener> listeners) {
        this.listeners.addAll(listeners);
        return this;
    }

    public Store removeListener(Listener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public Store removeListener() {
        this.listeners.clear();
        return this;
    }

    public Store setProxy(URI proxy) {
        if (proxy != null && proxy.getUserInfo() != null) {
            ProxyAuthenticator.register(proxy);
        } else if (proxy == null && this.proxy != null && this.proxy.getUserInfo() != null) {
            ProxyAuthenticator.unregister(this.proxy);
        }
        this.proxy = proxy;
        return this;
    }

    public Optional<URI> proxy() {
        return Optional.ofNullable(this.proxy);
    }

    public Optional<String> businessAddress() {
        return Optional.ofNullable(this.businessAddress);
    }

    public Optional<Double> businessLongitude() {
        return Optional.ofNullable(this.businessLongitude);
    }

    public Optional<Double> businessLatitude() {
        return Optional.ofNullable(this.businessLatitude);
    }

    public Optional<String> businessDescription() {
        return Optional.ofNullable(this.businessDescription);
    }

    public Optional<String> businessWebsite() {
        return Optional.ofNullable(this.businessWebsite);
    }

    public Optional<String> businessEmail() {
        return Optional.ofNullable(this.businessEmail);
    }

    public Optional<BusinessCategory> businessCategory() {
        return Optional.ofNullable(this.businessCategory);
    }

    @Override
    public void dispose() {
        this.serialize(false);
        this.serializer.linkMetadata(this);
        this.mediaConnectionLatch.countDown();
    }

    @Override
    public void serialize(boolean async) {
        this.serializer.serializeStore(this, async);
    }

    public Optional<Call> addCall(Call call) {
        return Optional.ofNullable(this.calls.put(call.id(), call));
    }

    public Optional<Call> findCallById(String callId) {
        return callId == null ? Optional.empty() : Optional.ofNullable(this.calls.get(callId));
    }

    public String tag() {
        return this.tag;
    }

    @JsonGetter(value="version")
    public Version version() {
        if (this.version == null) {
            this.version = new FutureReference<Object>(null, () -> TokenProvider.getVersion(this.device.platform()));
        }
        return this.version.value();
    }

    public boolean online() {
        return this.online;
    }

    public Optional<CountryLocale> locale() {
        return Optional.ofNullable(this.locale);
    }

    public String name() {
        return this.name;
    }

    public Optional<String> deviceHash() {
        return Optional.ofNullable(this.deviceHash);
    }

    public Optional<String> about() {
        return Optional.ofNullable(this.about);
    }

    public Optional<Jid> jid() {
        return Optional.ofNullable(this.jid);
    }

    public Optional<Jid> lid() {
        return Optional.ofNullable(this.lid);
    }

    public boolean unarchiveChats() {
        return this.unarchiveChats;
    }

    public boolean twentyFourHourFormat() {
        return this.twentyFourHourFormat;
    }

    public long initializationTimeStamp() {
        return this.initializationTimeStamp;
    }

    public ChatEphemeralTimer newChatsEphemeralTimer() {
        return this.newChatsEphemeralTimer;
    }

    public TextPreviewSetting textPreviewSetting() {
        return this.textPreviewSetting;
    }

    public WebHistoryLength historyLength() {
        return this.historyLength;
    }

    public boolean autodetectListeners() {
        return this.autodetectListeners;
    }

    public boolean cacheDetectedListeners() {
        return this.cacheDetectedListeners;
    }

    public boolean automaticPresenceUpdates() {
        return this.automaticPresenceUpdates;
    }

    public UserAgent.ReleaseChannel releaseChannel() {
        return this.releaseChannel;
    }

    public CompanionDevice device() {
        return this.device;
    }

    public boolean checkPatchMacs() {
        return this.checkPatchMacs;
    }

    public Store setOnline(boolean online) {
        this.online = online;
        return this;
    }

    public Store setLocale(CountryLocale locale) {
        this.locale = locale;
        return this;
    }

    public Store setName(String name) {
        this.name = name;
        return this;
    }

    public Store setBusinessAddress(String businessAddress) {
        this.businessAddress = businessAddress;
        return this;
    }

    public Store setBusinessLongitude(Double businessLongitude) {
        this.businessLongitude = businessLongitude;
        return this;
    }

    public Store setBusinessLatitude(Double businessLatitude) {
        this.businessLatitude = businessLatitude;
        return this;
    }

    public Store setBusinessDescription(String businessDescription) {
        this.businessDescription = businessDescription;
        return this;
    }

    public Store setBusinessWebsite(String businessWebsite) {
        this.businessWebsite = businessWebsite;
        return this;
    }

    public Store setBusinessEmail(String businessEmail) {
        this.businessEmail = businessEmail;
        return this;
    }

    public Store setBusinessCategory(BusinessCategory businessCategory) {
        this.businessCategory = businessCategory;
        return this;
    }

    public Store setDeviceHash(String deviceHash) {
        this.deviceHash = deviceHash;
        return this;
    }

    public Store setLinkedDevicesKeys(LinkedHashMap<Jid, Integer> linkedDevicesKeys) {
        this.linkedDevicesKeys = linkedDevicesKeys;
        return this;
    }

    public Store setProfilePicture(URI profilePicture) {
        this.profilePicture = profilePicture;
        return this;
    }

    public Store setAbout(String about) {
        this.about = about;
        return this;
    }

    public Store setJid(Jid jid) {
        this.jid = jid;
        return this;
    }

    public Store setLid(Jid lid) {
        this.lid = lid;
        return this;
    }

    public Store setUnarchiveChats(boolean unarchiveChats) {
        this.unarchiveChats = unarchiveChats;
        return this;
    }

    public Store setTwentyFourHourFormat(boolean twentyFourHourFormat) {
        this.twentyFourHourFormat = twentyFourHourFormat;
        return this;
    }

    public Store setNewChatsEphemeralTimer(ChatEphemeralTimer newChatsEphemeralTimer) {
        this.newChatsEphemeralTimer = newChatsEphemeralTimer;
        return this;
    }

    public Store setTextPreviewSetting(TextPreviewSetting textPreviewSetting) {
        this.textPreviewSetting = textPreviewSetting;
        return this;
    }

    public Store setHistoryLength(WebHistoryLength historyLength) {
        this.historyLength = historyLength;
        return this;
    }

    public Store setAutodetectListeners(boolean autodetectListeners) {
        this.autodetectListeners = autodetectListeners;
        return this;
    }

    public void setCacheDetectedListeners(boolean cacheDetectedListeners) {
        this.cacheDetectedListeners = cacheDetectedListeners;
    }

    public Store setAutomaticPresenceUpdates(boolean automaticPresenceUpdates) {
        this.automaticPresenceUpdates = automaticPresenceUpdates;
        return this;
    }

    public Store setReleaseChannel(UserAgent.ReleaseChannel releaseChannel) {
        this.releaseChannel = releaseChannel;
        return this;
    }

    public Store setDevice(CompanionDevice device) {
        Objects.requireNonNull(device, "The device cannot be null");
        this.device = device;
        this.version = new FutureReference<Object>(null, () -> TokenProvider.getVersion(device.platform()));
        return this;
    }

    public Store setCheckPatchMacs(boolean checkPatchMacs) {
        this.checkPatchMacs = checkPatchMacs;
        return this;
    }

    public Store setVersion(Version version) {
        this.version.setValue(version);
        return this;
    }
}

