/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.crypto;

import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.crypto.AesCbc;
import it.auties.whatsapp.crypto.CipheredMessageResult;
import it.auties.whatsapp.model.signal.message.SenderKeyMessage;
import it.auties.whatsapp.model.signal.sender.SenderChainKey;
import it.auties.whatsapp.model.signal.sender.SenderKeyName;
import it.auties.whatsapp.model.signal.sender.SenderKeyRecord;
import it.auties.whatsapp.model.signal.sender.SenderKeyState;
import it.auties.whatsapp.model.signal.sender.SenderMessageKey;
import java.util.List;
import java.util.NoSuchElementException;

public record GroupCipher(SenderKeyName name, Keys keys) {
    public CipheredMessageResult encrypt(byte[] data) {
        if (data == null) {
            return new CipheredMessageResult(null, "unavailable");
        }
        SenderKeyState currentState = this.keys.findSenderKeyByName(this.name).findState();
        SenderMessageKey messageKey = currentState.chainKey().toMessageKey();
        byte[] ciphertext = AesCbc.encrypt(messageKey.iv(), data, messageKey.cipherKey());
        SenderKeyMessage senderKeyMessage = new SenderKeyMessage(currentState.id(), messageKey.iteration(), ciphertext, currentState.signingKey().privateKey());
        SenderChainKey next = currentState.chainKey().next();
        currentState.setChainKey(next);
        return new CipheredMessageResult(senderKeyMessage.serialized(), "skmsg");
    }

    public byte[] decrypt(byte[] data) {
        SenderKeyRecord record = this.keys.findSenderKeyByName(this.name);
        SenderKeyMessage senderKeyMessage = SenderKeyMessage.ofSerialized(data);
        List<SenderKeyState> senderKeyStates = record.findStateById(senderKeyMessage.id());
        for (SenderKeyState senderKeyState : senderKeyStates) {
            try {
                SenderMessageKey senderKey = this.getSenderKey(senderKeyState, senderKeyMessage.iteration());
                return AesCbc.decrypt(senderKey.iv(), senderKeyMessage.cipherText(), senderKey.cipherKey());
            }
            catch (Throwable throwable) {
            }
        }
        throw new RuntimeException("Cannot decode message with any session");
    }

    private SenderMessageKey getSenderKey(SenderKeyState senderKeyState, int iteration) {
        if (senderKeyState.chainKey().iteration() > iteration) {
            return senderKeyState.findSenderMessageKey(iteration).orElseThrow(() -> new NoSuchElementException("Received message with old counter: got %s, expected more than %s".formatted(iteration, senderKeyState.chainKey().iteration())));
        }
        SenderChainKey lastChainKey = senderKeyState.chainKey();
        while (lastChainKey.iteration() < iteration) {
            senderKeyState.addSenderMessageKey(lastChainKey.toMessageKey());
            lastChainKey = lastChainKey.next();
        }
        senderKeyState.setChainKey(lastChainKey.next());
        return lastChainKey.toMessageKey();
    }
}

