/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.button.base;

import it.auties.protobuf.annotation.ProtobufMessageName;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.button.base.ButtonBody;
import it.auties.whatsapp.model.button.base.ButtonBuilder;
import it.auties.whatsapp.model.button.base.ButtonText;
import it.auties.whatsapp.model.info.NativeFlowInfo;
import it.auties.whatsapp.util.BytesHelper;
import java.lang.runtime.SwitchBootstraps;
import java.util.HexFormat;
import java.util.Optional;

@ProtobufMessageName(value="Message.ButtonsMessage.Button")
public record Button(@ProtobufProperty(index=1, type=ProtobufType.STRING) String id, @ProtobufProperty(index=2, type=ProtobufType.OBJECT) Optional<ButtonText> bodyText, @ProtobufProperty(index=4, type=ProtobufType.OBJECT) Optional<NativeFlowInfo> bodyNativeFlow, @ProtobufProperty(index=3, type=ProtobufType.OBJECT) ButtonBody.Type bodyType) implements ProtobufMessage
{
    public static Button of(ButtonBody body) {
        String id = HexFormat.of().formatHex(BytesHelper.random(6));
        return Button.of(id, body);
    }

    public static Button of(String id, ButtonBody body) {
        ButtonBuilder builder = new ButtonBuilder().id(id);
        ButtonBody buttonBody = body;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ButtonText.class, NativeFlowInfo.class}, (Object)buttonBody, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ButtonText buttonText = (ButtonText)buttonBody;
                builder.bodyText(buttonText).bodyType(ButtonBody.Type.TEXT);
                break;
            }
            case 1: {
                NativeFlowInfo flowInfo = (NativeFlowInfo)buttonBody;
                builder.bodyNativeFlow(flowInfo).bodyType(ButtonBody.Type.NATIVE_FLOW);
                break;
            }
            case -1: {
                builder.bodyType(ButtonBody.Type.UNKNOWN);
            }
        }
        return builder.build();
    }

    public Optional<? extends ButtonBody> body() {
        return this.bodyText.isPresent() ? this.bodyText : this.bodyNativeFlow;
    }
}

