/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.button.template.hydrated;

import it.auties.protobuf.annotation.ProtobufBuilder;
import it.auties.protobuf.annotation.ProtobufMessageName;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.button.template.TemplateFormatter;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateBuilder;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTextTitle;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTitle;
import it.auties.whatsapp.model.button.template.hydrated.HydratedTemplateButton;
import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.LocationMessage;
import it.auties.whatsapp.model.message.standard.VideoOrGifMessage;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;

@ProtobufMessageName(value="Message.TemplateMessage.HydratedFourRowTemplate")
public record HydratedFourRowTemplate(@ProtobufProperty(index=1, type=ProtobufType.OBJECT) Optional<DocumentMessage> titleDocument, @ProtobufProperty(index=2, type=ProtobufType.STRING) Optional<HydratedFourRowTemplateTextTitle> titleText, @ProtobufProperty(index=3, type=ProtobufType.OBJECT) Optional<ImageMessage> titleImage, @ProtobufProperty(index=4, type=ProtobufType.OBJECT) Optional<VideoOrGifMessage> titleVideo, @ProtobufProperty(index=5, type=ProtobufType.OBJECT) Optional<LocationMessage> titleLocation, @ProtobufProperty(index=6, type=ProtobufType.STRING) String body, @ProtobufProperty(index=7, type=ProtobufType.STRING) Optional<String> footer, @ProtobufProperty(index=8, type=ProtobufType.OBJECT, repeated=true) List<HydratedTemplateButton> hydratedButtons, @ProtobufProperty(index=9, type=ProtobufType.STRING) String templateId) implements TemplateFormatter
{
    @ProtobufBuilder(className="HydratedFourRowTemplateSimpleBuilder")
    static HydratedFourRowTemplate customBuilder(HydratedFourRowTemplateTitle title, String body, String footer, List<HydratedTemplateButton> buttons, String templateId) {
        HydratedFourRowTemplateBuilder builder = new HydratedFourRowTemplateBuilder().templateId(templateId).body(body).hydratedButtons(HydratedFourRowTemplate.getIndexedButtons(buttons)).footer(footer);
        HydratedFourRowTemplateTitle hydratedFourRowTemplateTitle = title;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DocumentMessage.class, HydratedFourRowTemplateTextTitle.class, ImageMessage.class, VideoOrGifMessage.class, LocationMessage.class}, (Object)hydratedFourRowTemplateTitle, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DocumentMessage documentMessage = (DocumentMessage)hydratedFourRowTemplateTitle;
                builder.titleDocument(documentMessage);
                break;
            }
            case 1: {
                HydratedFourRowTemplateTextTitle hydratedFourRowTemplateTextTitle = (HydratedFourRowTemplateTextTitle)hydratedFourRowTemplateTitle;
                builder.titleText(hydratedFourRowTemplateTextTitle);
                break;
            }
            case 2: {
                ImageMessage imageMessage = (ImageMessage)hydratedFourRowTemplateTitle;
                builder.titleImage(imageMessage);
                break;
            }
            case 3: {
                VideoOrGifMessage videoMessage = (VideoOrGifMessage)hydratedFourRowTemplateTitle;
                builder.titleVideo(videoMessage);
                break;
            }
            case 4: {
                LocationMessage locationMessage = (LocationMessage)hydratedFourRowTemplateTitle;
                builder.titleLocation(locationMessage);
            }
            case -1: 
        }
        return builder.build();
    }

    private static List<HydratedTemplateButton> getIndexedButtons(List<HydratedTemplateButton> buttons) {
        return IntStream.range(0, buttons.size()).mapToObj(index -> {
            HydratedTemplateButton button = (HydratedTemplateButton)buttons.get(index);
            return new HydratedTemplateButton(button.quickReplyButton(), button.urlButton(), button.callButton(), index + 1);
        }).toList();
    }

    public HydratedFourRowTemplateTitle.Type titleType() {
        return this.title().map(HydratedFourRowTemplateTitle::hydratedTitleType).orElse(HydratedFourRowTemplateTitle.Type.NONE);
    }

    public Optional<? extends HydratedFourRowTemplateTitle> title() {
        if (this.titleDocument.isPresent()) {
            return this.titleDocument;
        }
        if (this.titleText.isPresent()) {
            return this.titleText;
        }
        if (this.titleImage.isPresent()) {
            return this.titleImage;
        }
        if (this.titleVideo.isPresent()) {
            return this.titleVideo;
        }
        return this.titleLocation;
    }

    @Override
    public TemplateFormatter.Type templateType() {
        return TemplateFormatter.Type.HYDRATED_FOUR_ROW;
    }
}

