/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.chat;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatDisappear;
import it.auties.whatsapp.model.chat.ChatDisappearSpec;
import it.auties.whatsapp.model.chat.ChatEndOfHistoryTransferTypeSpec;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.chat.ChatMute;
import it.auties.whatsapp.model.chat.ChatWallpaper;
import it.auties.whatsapp.model.chat.ChatWallpaperSpec;
import it.auties.whatsapp.model.chat.GroupParticipant;
import it.auties.whatsapp.model.chat.GroupParticipantSpec;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.media.MediaVisibility;
import it.auties.whatsapp.model.media.MediaVisibilitySpec;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.whatsapp.model.sync.HistorySyncMessageSpec;
import it.auties.whatsapp.util.ConcurrentLinkedHashedDequeue;
import java.util.ArrayList;
import java.util.Optional;

public class ChatSpec {
    public static byte[] encode(Chat protoInputObject) {
        String lidJid1;
        Jid lidJid0;
        String phoneJid1;
        Jid phoneJid0;
        Optional<Jid> phoneJid;
        String displayName0;
        Optional<String> displayName;
        String parentGroupJid1;
        Jid parentGroupJid0;
        String description0;
        Optional<String> description;
        String founder1;
        Jid founder0;
        ChatWallpaper wallpaper0;
        Optional<ChatWallpaper> wallpaper;
        byte[] identityKey0;
        byte[] token0;
        Optional<byte[]> token;
        Object disappearInitiator0;
        Chat.EndOfHistoryTransferType endOfHistoryTransferType0;
        String oldJid1;
        Jid oldJid0;
        Optional<Jid> oldJid;
        String newJid1;
        Jid newJid0;
        Optional<Jid> newJid;
        Object jid0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Jid jid = protoInputObject.jid();
        if (jid != null && (jid0 = jid.toProtobufValue()) != null) {
            outputStream.writeString(1, (String)jid0);
        }
        if (protoInputObject.historySyncMessages() != null) {
            for (HistorySyncMessage historySyncMessagesEntry : protoInputObject.historySyncMessages()) {
                outputStream.writeBytes(2, HistorySyncMessageSpec.encode(historySyncMessagesEntry));
            }
        }
        if ((newJid = protoInputObject.newJid()) != null && (newJid0 = (Jid)newJid.orElse(null)) != null && (newJid1 = newJid0.toProtobufValue()) != null) {
            outputStream.writeString(3, newJid1);
        }
        if ((oldJid = protoInputObject.oldJid()) != null && (oldJid0 = (Jid)oldJid.orElse(null)) != null && (oldJid1 = oldJid0.toProtobufValue()) != null) {
            outputStream.writeString(4, oldJid1);
        }
        outputStream.writeUInt32(6, Integer.valueOf(protoInputObject.unreadMessagesCount()));
        outputStream.writeBool(7, Boolean.valueOf(protoInputObject.readOnly()));
        outputStream.writeBool(8, Boolean.valueOf(protoInputObject.endOfHistoryTransfer()));
        ChatEphemeralTimer ephemeralMessageDuration = protoInputObject.ephemeralMessageDuration();
        if (ephemeralMessageDuration != null) {
            int ephemeralMessageDuration0 = ephemeralMessageDuration.periodSeconds();
            outputStream.writeUInt32(9, Integer.valueOf(ephemeralMessageDuration0));
        }
        outputStream.writeInt64(10, Long.valueOf(protoInputObject.ephemeralMessagesToggleTimeSeconds()));
        Optional<Chat.EndOfHistoryTransferType> endOfHistoryTransferType = protoInputObject.endOfHistoryTransferType();
        if (endOfHistoryTransferType != null && (endOfHistoryTransferType0 = (Chat.EndOfHistoryTransferType)endOfHistoryTransferType.orElse(null)) != null) {
            outputStream.writeInt32(11, ChatEndOfHistoryTransferTypeSpec.encode(endOfHistoryTransferType0));
        }
        outputStream.writeUInt64(12, Long.valueOf(protoInputObject.timestampSeconds()));
        outputStream.writeString(13, protoInputObject.name());
        outputStream.writeBool(15, Boolean.valueOf(protoInputObject.notSpam()));
        outputStream.writeBool(16, Boolean.valueOf(protoInputObject.archived()));
        Optional<ChatDisappear> disappearInitiator = protoInputObject.disappearInitiator();
        if (disappearInitiator != null && (disappearInitiator0 = (ChatDisappear)disappearInitiator.orElse(null)) != null) {
            outputStream.writeBytes(17, ChatDisappearSpec.encode((ChatDisappear)disappearInitiator0));
        }
        outputStream.writeBool(19, Boolean.valueOf(protoInputObject.markedAsUnread()));
        if (protoInputObject.participants() != null) {
            for (GroupParticipant participantsEntry : protoInputObject.participants()) {
                outputStream.writeBytes(20, GroupParticipantSpec.encode(participantsEntry));
            }
        }
        if ((token = protoInputObject.token()) != null && (token0 = (byte[])token.orElse(null)) != null) {
            outputStream.writeBytes(21, token0);
        }
        outputStream.writeUInt64(22, Long.valueOf(protoInputObject.tokenTimestampSeconds()));
        Optional<byte[]> identityKey = protoInputObject.identityKey();
        if (identityKey != null && (identityKey0 = (byte[])identityKey.orElse(null)) != null) {
            outputStream.writeBytes(23, identityKey0);
        }
        outputStream.writeUInt32(24, Integer.valueOf(protoInputObject.pinnedTimestampSeconds()));
        ChatMute mute = protoInputObject.mute();
        if (mute != null) {
            long mute0 = mute.endTimeStamp();
            outputStream.writeUInt64(25, Long.valueOf(mute0));
        }
        if ((wallpaper = protoInputObject.wallpaper()) != null && (wallpaper0 = (ChatWallpaper)wallpaper.orElse(null)) != null) {
            outputStream.writeBytes(26, ChatWallpaperSpec.encode(wallpaper0));
        }
        outputStream.writeInt32(27, MediaVisibilitySpec.encode(protoInputObject.mediaVisibility()));
        outputStream.writeUInt64(28, Long.valueOf(protoInputObject.tokenSenderTimestampSeconds()));
        outputStream.writeBool(29, Boolean.valueOf(protoInputObject.suspended()));
        outputStream.writeBool(30, Boolean.valueOf(protoInputObject.terminated()));
        outputStream.writeUInt64(31, Long.valueOf(protoInputObject.foundationTimestampSeconds()));
        Optional<Jid> founder = protoInputObject.founder();
        if (founder != null && (founder0 = (Jid)founder.orElse(null)) != null && (founder1 = founder0.toProtobufValue()) != null) {
            outputStream.writeString(32, founder1);
        }
        if ((description = protoInputObject.description()) != null && (description0 = (String)description.orElse(null)) != null) {
            outputStream.writeString(33, description0);
        }
        outputStream.writeBool(34, Boolean.valueOf(protoInputObject.support()));
        outputStream.writeBool(35, Boolean.valueOf(protoInputObject.parentGroup()));
        outputStream.writeBool(36, Boolean.valueOf(protoInputObject.defaultSubGroup()));
        Optional<Jid> parentGroupJid = protoInputObject.parentGroupJid();
        if (parentGroupJid != null && (parentGroupJid0 = (Jid)parentGroupJid.orElse(null)) != null && (parentGroupJid1 = parentGroupJid0.toProtobufValue()) != null) {
            outputStream.writeString(37, parentGroupJid1);
        }
        if ((displayName = protoInputObject.displayName()) != null && (displayName0 = (String)displayName.orElse(null)) != null) {
            outputStream.writeString(38, displayName0);
        }
        if ((phoneJid = protoInputObject.phoneJid()) != null && (phoneJid0 = (Jid)phoneJid.orElse(null)) != null && (phoneJid1 = phoneJid0.toProtobufValue()) != null) {
            outputStream.writeString(39, phoneJid1);
        }
        outputStream.writeBool(40, Boolean.valueOf(protoInputObject.shareOwnPhoneNumber()));
        outputStream.writeBool(41, Boolean.valueOf(protoInputObject.pnhDuplicateLidThread()));
        Optional<Jid> lidJid = protoInputObject.lidJid();
        if (lidJid != null && (lidJid0 = (Jid)lidJid.orElse(null)) != null && (lidJid1 = lidJid0.toProtobufValue()) != null) {
            outputStream.writeString(42, lidJid1);
        }
        return outputStream.toByteArray();
    }

    public static Chat decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        Jid jid = null;
        ConcurrentLinkedHashedDequeue<HistorySyncMessage> historySyncMessages = new ConcurrentLinkedHashedDequeue<HistorySyncMessage>();
        Jid newJid = null;
        Jid oldJid = null;
        int unreadMessagesCount = 0;
        boolean readOnly = false;
        boolean endOfHistoryTransfer = false;
        ChatEphemeralTimer ephemeralMessageDuration = null;
        long ephemeralMessagesToggleTimeSeconds = 0L;
        Chat.EndOfHistoryTransferType endOfHistoryTransferType = null;
        long timestampSeconds = 0L;
        String name = null;
        boolean notSpam = false;
        boolean archived = false;
        ChatDisappear disappearInitiator = null;
        boolean markedAsUnread = false;
        ArrayList<GroupParticipant> participants = new ArrayList<GroupParticipant>();
        byte[] token = null;
        long tokenTimestampSeconds = 0L;
        byte[] identityKey = null;
        int pinnedTimestampSeconds = 0;
        ChatMute mute = null;
        ChatWallpaper wallpaper = null;
        MediaVisibility mediaVisibility = null;
        long tokenSenderTimestampSeconds = 0L;
        boolean suspended = false;
        boolean terminated = false;
        long foundationTimestampSeconds = 0L;
        Jid founder = null;
        String description = null;
        boolean support = false;
        boolean parentGroup = false;
        boolean defaultSubGroup = false;
        Jid parentGroupJid = null;
        String displayName = null;
        Jid phoneJid = null;
        boolean shareOwnPhoneNumber = false;
        boolean pnhDuplicateLidThread = false;
        Jid lidJid = null;
        block41: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    jid = Jid.ofProtobuf(inputStream.readString());
                    continue block41;
                }
                case 2: {
                    historySyncMessages.add(HistorySyncMessageSpec.decode(inputStream.readBytes()));
                    continue block41;
                }
                case 3: {
                    newJid = Jid.ofProtobuf(inputStream.readString());
                    continue block41;
                }
                case 4: {
                    oldJid = Jid.ofProtobuf(inputStream.readString());
                    continue block41;
                }
                case 6: {
                    unreadMessagesCount = inputStream.readInt32();
                    continue block41;
                }
                case 7: {
                    readOnly = inputStream.readBool();
                    continue block41;
                }
                case 8: {
                    endOfHistoryTransfer = inputStream.readBool();
                    continue block41;
                }
                case 9: {
                    ephemeralMessageDuration = ChatEphemeralTimer.of(inputStream.readInt32());
                    continue block41;
                }
                case 10: {
                    ephemeralMessagesToggleTimeSeconds = inputStream.readInt64();
                    continue block41;
                }
                case 11: {
                    endOfHistoryTransferType = ChatEndOfHistoryTransferTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block41;
                }
                case 12: {
                    timestampSeconds = inputStream.readInt64();
                    continue block41;
                }
                case 13: {
                    name = inputStream.readString();
                    continue block41;
                }
                case 15: {
                    notSpam = inputStream.readBool();
                    continue block41;
                }
                case 16: {
                    archived = inputStream.readBool();
                    continue block41;
                }
                case 17: {
                    disappearInitiator = ChatDisappearSpec.decode(inputStream.readBytes());
                    continue block41;
                }
                case 19: {
                    markedAsUnread = inputStream.readBool();
                    continue block41;
                }
                case 20: {
                    participants.add(GroupParticipantSpec.decode(inputStream.readBytes()));
                    continue block41;
                }
                case 21: {
                    token = inputStream.readBytes();
                    continue block41;
                }
                case 22: {
                    tokenTimestampSeconds = inputStream.readInt64();
                    continue block41;
                }
                case 23: {
                    identityKey = inputStream.readBytes();
                    continue block41;
                }
                case 24: {
                    pinnedTimestampSeconds = inputStream.readInt32();
                    continue block41;
                }
                case 25: {
                    mute = ChatMute.ofProtobuf(inputStream.readInt64());
                    continue block41;
                }
                case 26: {
                    wallpaper = ChatWallpaperSpec.decode(inputStream.readBytes());
                    continue block41;
                }
                case 27: {
                    mediaVisibility = MediaVisibilitySpec.decode(inputStream.readInt32()).orElse(null);
                    continue block41;
                }
                case 28: {
                    tokenSenderTimestampSeconds = inputStream.readInt64();
                    continue block41;
                }
                case 29: {
                    suspended = inputStream.readBool();
                    continue block41;
                }
                case 30: {
                    terminated = inputStream.readBool();
                    continue block41;
                }
                case 31: {
                    foundationTimestampSeconds = inputStream.readInt64();
                    continue block41;
                }
                case 32: {
                    founder = Jid.ofProtobuf(inputStream.readString());
                    continue block41;
                }
                case 33: {
                    description = inputStream.readString();
                    continue block41;
                }
                case 34: {
                    support = inputStream.readBool();
                    continue block41;
                }
                case 35: {
                    parentGroup = inputStream.readBool();
                    continue block41;
                }
                case 36: {
                    defaultSubGroup = inputStream.readBool();
                    continue block41;
                }
                case 37: {
                    parentGroupJid = Jid.ofProtobuf(inputStream.readString());
                    continue block41;
                }
                case 38: {
                    displayName = inputStream.readString();
                    continue block41;
                }
                case 39: {
                    phoneJid = Jid.ofProtobuf(inputStream.readString());
                    continue block41;
                }
                case 40: {
                    shareOwnPhoneNumber = inputStream.readBool();
                    continue block41;
                }
                case 41: {
                    pnhDuplicateLidThread = inputStream.readBool();
                    continue block41;
                }
                case 42: {
                    lidJid = Jid.ofProtobuf(inputStream.readString());
                    continue block41;
                }
            }
            inputStream.skipBytes();
        }
        return new Chat(jid, historySyncMessages, newJid, oldJid, unreadMessagesCount, readOnly, endOfHistoryTransfer, ephemeralMessageDuration, ephemeralMessagesToggleTimeSeconds, endOfHistoryTransferType, timestampSeconds, name, notSpam, archived, disappearInitiator, markedAsUnread, participants, token, tokenTimestampSeconds, identityKey, pinnedTimestampSeconds, mute, wallpaper, mediaVisibility, tokenSenderTimestampSeconds, suspended, terminated, foundationTimestampSeconds, founder, description, support, parentGroup, defaultSubGroup, parentGroupJid, displayName, phoneJid, shareOwnPhoneNumber, pnhDuplicateLidThread, lidJid);
    }
}

