/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.companion;

import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;

public record CompanionDevice(String model, String manufacturer, UserAgent.PlatformType platform, String version) {
    public static CompanionDevice web() {
        return new CompanionDevice("Chrome", "Google", UserAgent.PlatformType.WEB, "1.0");
    }

    public static CompanionDevice ios(boolean business) {
        return new CompanionDevice("iPhone_X", "Apple", business ? UserAgent.PlatformType.IOS_BUSINESS : UserAgent.PlatformType.IOS, "16.5.1");
    }

    public static CompanionDevice android(boolean business) {
        return new CompanionDevice("P60", "HUAWEI", business ? UserAgent.PlatformType.ANDROID_BUSINESS : UserAgent.PlatformType.ANDROID, "10.11.0");
    }

    public static CompanionDevice kaiOs() {
        return new CompanionDevice("8110", "Nokia", UserAgent.PlatformType.KAIOS, "2.5.4");
    }

    public String toUserAgent(Version appVersion) {
        return "WhatsApp/%s %s/%s Device/%s".formatted(appVersion, this.platformName(), this.deviceVersion(), this.deviceName());
    }

    private String deviceVersion() {
        if (this.platform.isKaiOs()) {
            return "%s+20190925153113".formatted(this.version);
        }
        return this.version;
    }

    private String deviceName() {
        return switch (this.platform()) {
            case UserAgent.PlatformType.ANDROID, UserAgent.PlatformType.ANDROID_BUSINESS -> this.manufacturer + " " + this.model;
            case UserAgent.PlatformType.IOS, UserAgent.PlatformType.IOS_BUSINESS -> this.model;
            case UserAgent.PlatformType.KAIOS -> this.manufacturer + "+" + this.model;
            default -> throw new IllegalStateException("Unsupported mobile os");
        };
    }

    private String platformName() {
        return switch (this.platform()) {
            case UserAgent.PlatformType.ANDROID -> "Android";
            case UserAgent.PlatformType.ANDROID_BUSINESS -> "SMBA";
            case UserAgent.PlatformType.IOS -> "iOS";
            case UserAgent.PlatformType.IOS_BUSINESS -> "SMB iOS";
            case UserAgent.PlatformType.KAIOS -> "KaiOS";
            default -> throw new IllegalStateException("Unsupported mobile os");
        };
    }
}

