/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.companion;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.whatsapp.model.node.Attributes;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.sync.PatchType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class CompanionHashState {
    private PatchType name;
    private long version;
    private byte[] hash;
    private Map<String, byte[]> indexValueMap;

    public CompanionHashState(PatchType name) {
        this(name, 0L);
    }

    public CompanionHashState(PatchType name, long version) {
        this.name = name;
        this.version = version;
        this.hash = new byte[128];
        this.indexValueMap = new HashMap<String, byte[]>();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public CompanionHashState(PatchType name, long version, byte[] hash, Map<String, byte[]> indexValueMap) {
        this.name = name;
        this.version = version;
        this.hash = hash;
        this.indexValueMap = indexValueMap;
    }

    public Node toNode() {
        LinkedHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("name", (Object)this.name).put("version", this.version).put("return_snapshot", this.version == 0L).toMap();
        return Node.of("collection", attributes);
    }

    public CompanionHashState copy() {
        return new CompanionHashState(this.name, this.version, Arrays.copyOf(this.hash, this.hash.length), new HashMap<String, byte[]>(this.indexValueMap));
    }

    private boolean checkIndexEquality(CompanionHashState that) {
        if (this.indexValueMap.size() != that.indexValueMap().size()) {
            return false;
        }
        return this.indexValueMap().entrySet().stream().allMatch(entry -> CompanionHashState.checkIndexEntryEquality(that, (String)entry.getKey(), (byte[])entry.getValue()));
    }

    private static boolean checkIndexEntryEquality(CompanionHashState that, String thisKey, byte[] thisValue) {
        byte[] thatValue = that.indexValueMap().get(thisKey);
        return thatValue != null && Arrays.equals(thatValue, thisValue);
    }

    public PatchType name() {
        return this.name;
    }

    public long version() {
        return this.version;
    }

    public byte[] hash() {
        return this.hash;
    }

    public Map<String, byte[]> indexValueMap() {
        return this.indexValueMap;
    }

    public CompanionHashState name(PatchType name) {
        this.name = name;
        return this;
    }

    public CompanionHashState version(long version) {
        this.version = version;
        return this;
    }

    public CompanionHashState hash(byte[] hash) {
        this.hash = hash;
        return this;
    }

    public CompanionHashState indexValueMap(Map<String, byte[]> indexValueMap) {
        this.indexValueMap = indexValueMap;
        return this;
    }

    public boolean equals(Object o) {
        CompanionHashState that;
        return o instanceof CompanionHashState && this.version == (that = (CompanionHashState)o).version() && this.name == that.name() && Arrays.equals(this.hash, that.hash()) && this.checkIndexEquality(that);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.name, this.version, this.indexValueMap});
        result = 31 * result + Arrays.hashCode(this.hash);
        return result;
    }
}

