/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.contact;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.util.Clock;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

public final class Contact
implements JidProvider {
    private final Jid jid;
    private String chosenName;
    private String fullName;
    private String shortName;
    private ContactStatus lastKnownPresence;
    private ZonedDateTime lastSeen;
    private boolean blocked;

    public Contact(Jid jid) {
        this.jid = jid;
        this.lastKnownPresence = ContactStatus.UNAVAILABLE;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Contact(Jid jid, String chosenName, String fullName, String shortName, ContactStatus lastKnownPresence, Long lastSeenSeconds, boolean blocked) {
        this.jid = jid;
        this.chosenName = chosenName;
        this.fullName = fullName;
        this.shortName = shortName;
        this.lastKnownPresence = lastKnownPresence;
        this.lastSeen = Clock.parseSeconds(lastSeenSeconds).orElse(null);
        this.blocked = blocked;
    }

    public Jid jid() {
        return this.jid;
    }

    public String name() {
        if (this.shortName != null) {
            return this.shortName;
        }
        if (this.fullName != null) {
            return this.fullName;
        }
        if (this.chosenName != null) {
            return this.chosenName;
        }
        return this.jid().user();
    }

    public Optional<ZonedDateTime> lastSeen() {
        return Optional.ofNullable(this.lastSeen);
    }

    public Optional<String> chosenName() {
        return Optional.ofNullable(this.chosenName);
    }

    public Optional<String> fullName() {
        return Optional.ofNullable(this.fullName);
    }

    public Optional<String> shortName() {
        return Optional.ofNullable(this.shortName);
    }

    public ContactStatus lastKnownPresence() {
        return this.lastKnownPresence;
    }

    public boolean blocked() {
        return this.blocked;
    }

    public Contact setChosenName(String chosenName) {
        this.chosenName = chosenName;
        return this;
    }

    public Contact setFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public Contact setShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public Contact setLastKnownPresence(ContactStatus lastKnownPresence) {
        this.lastKnownPresence = lastKnownPresence;
        return this;
    }

    public Contact setLastSeen(ZonedDateTime lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    public Contact setBlocked(boolean blocked) {
        this.blocked = blocked;
        return this;
    }

    @JsonGetter(value="lastSeen")
    Long lastSeenValue() {
        return this.lastSeen != null ? Long.valueOf(this.lastSeen.toEpochSecond()) : null;
    }

    public int hashCode() {
        return Objects.hashCode(this.jid());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof Contact)) return false;
        Contact that = (Contact)other;
        if (!Objects.equals(this.jid(), that.jid())) return false;
        return true;
    }

    @Override
    public Jid toJid() {
        return this.jid();
    }
}

