/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.contact;

import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.property.SimpleProperty;
import ezvcard.property.Telephone;
import it.auties.protobuf.annotation.ProtobufConverter;
import it.auties.whatsapp.model.jid.Jid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public sealed interface ContactCard {
    @ProtobufConverter
    public static ContactCard ofProtobuf(String vcard) {
        return vcard == null ? null : ContactCard.of(vcard);
    }

    public static ContactCard of(String vcard) {
        try {
            VCard parsed = Ezvcard.parse((String)vcard).first();
            Optional<String> version = Optional.ofNullable(parsed.getVersion().getVersion());
            Optional<String> name = Optional.ofNullable((String)parsed.getFormattedName().getValue());
            Map<String, List<Jid>> phoneNumbers = parsed.getTelephoneNumbers().stream().filter(ContactCard::isValidPhoneNumber).collect(Collectors.toUnmodifiableMap(ContactCard::getPhoneType, ContactCard::getPhoneValue, ContactCard::joinPhoneNumbers));
            Optional<String> businessName = Optional.ofNullable(parsed.getExtendedProperty("X-WA-BIZ-NAME")).map(SimpleProperty::getValue);
            return new Parsed(version, name, phoneNumbers, businessName);
        }
        catch (Throwable ignored) {
            return new Raw(vcard);
        }
    }

    private static boolean isValidPhoneNumber(Telephone entry) {
        return ContactCard.getPhoneType(entry) != null && entry.getParameter("WAID") != null;
    }

    private static String getPhoneType(Telephone entry) {
        return entry.getParameters().getType();
    }

    private static List<Jid> getPhoneValue(Telephone entry) {
        return List.of(Jid.of(entry.getParameter("WAID")));
    }

    private static List<Jid> joinPhoneNumbers(List<Jid> first, List<Jid> second) {
        return Stream.of(first, second).flatMap(Collection::stream).toList();
    }

    @ProtobufConverter
    public String toVcard();

    public record Parsed(Optional<String> version, Optional<String> name, Map<String, List<Jid>> phoneNumbers, Optional<String> businessName) implements ContactCard
    {
        public List<Jid> getPhoneNumber(Jid contact) {
            return Objects.requireNonNullElseGet(this.phoneNumbers.get("CELL"), List::of);
        }

        private void addPhoneNumber(VCard vcard, String type, Jid contact) {
            Telephone telephone = new Telephone(contact.toPhoneNumber());
            telephone.getParameters().setType(type);
            telephone.getParameters().put((Object)"WAID", (Object)contact.user());
            vcard.addTelephoneNumber(telephone);
        }

        public void addPhoneNumber(Jid contact) {
            this.addPhoneNumber("CELL", contact);
        }

        public void addPhoneNumber(String category, Jid contact) {
            List<Jid> oldValue = this.phoneNumbers.get(category);
            if (oldValue == null) {
                this.phoneNumbers.put(category, List.of(contact));
                return;
            }
            ArrayList<Jid> values = new ArrayList<Jid>(oldValue);
            values.add(contact);
            this.phoneNumbers.put(category, Collections.unmodifiableList(values));
        }

        @Override
        @ProtobufConverter
        public String toVcard() {
            VCard vcard = new VCard();
            vcard.setVersion(this.version().map(VCardVersion::valueOfByStr).orElse(VCardVersion.V3_0));
            vcard.setFormattedName((String)this.name.orElse(null));
            this.phoneNumbers().forEach((type, contacts) -> contacts.forEach(contact -> this.addPhoneNumber(vcard, (String)type, (Jid)contact)));
            this.businessName.ifPresent(value -> vcard.addExtendedProperty("X-WA-BIZ-NAME", value));
            return Ezvcard.write((VCard[])new VCard[]{vcard}).go();
        }
    }

    public record Raw(String toVcard) implements ContactCard
    {
    }
}

