/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import com.fasterxml.jackson.annotation.JsonBackReference;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.info.MessageStatusInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.newsletter.NewsletterReaction;
import it.auties.whatsapp.util.Clock;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public final class NewsletterMessageInfo
implements MessageInfo,
MessageStatusInfo<NewsletterMessageInfo> {
    @JsonBackReference
    private Newsletter newsletter;
    private final String id;
    private final int serverId;
    private final Long timestampSeconds;
    private final Long views;
    private final Map<String, NewsletterReaction> reactions;
    private final MessageContainer message;
    private MessageStatus status;

    public NewsletterMessageInfo(Newsletter newsletter, String id, int serverId, Long timestampSeconds, Long views, Map<String, NewsletterReaction> reactions, MessageContainer message, MessageStatus status) {
        this.newsletter = newsletter;
        this.id = id;
        this.serverId = serverId;
        this.timestampSeconds = timestampSeconds;
        this.views = views;
        this.reactions = reactions;
        this.message = message;
        this.status = status;
    }

    public NewsletterMessageInfo setNewsletter(Newsletter newsletter) {
        this.newsletter = newsletter;
        return this;
    }

    public Jid newsletterJid() {
        return this.newsletter.jid();
    }

    @Override
    public Jid parentJid() {
        return this.newsletterJid();
    }

    @Override
    public Jid senderJid() {
        return this.newsletterJid();
    }

    public Newsletter newsletter() {
        return this.newsletter;
    }

    @Override
    public String id() {
        return this.id;
    }

    public int serverId() {
        return this.serverId;
    }

    @Override
    public OptionalLong timestampSeconds() {
        return this.timestampSeconds == null ? OptionalLong.empty() : OptionalLong.of(this.timestampSeconds);
    }

    public OptionalLong views() {
        return this.views == null ? OptionalLong.empty() : OptionalLong.of(this.views);
    }

    @Override
    public MessageContainer message() {
        return this.message;
    }

    public Optional<ZonedDateTime> timestamp() {
        return Clock.parseSeconds(this.timestampSeconds);
    }

    @Override
    public MessageStatus status() {
        return this.status;
    }

    @Override
    public NewsletterMessageInfo setStatus(MessageStatus status) {
        this.status = status;
        return this;
    }

    public Collection<NewsletterReaction> reactions() {
        return Collections.unmodifiableCollection(this.reactions.values());
    }

    public Optional<NewsletterReaction> findReaction(String value) {
        return Optional.ofNullable(this.reactions.get(value));
    }

    public Optional<NewsletterReaction> addReaction(NewsletterReaction reaction) {
        return Optional.ofNullable(this.reactions.put(reaction.content(), reaction));
    }

    public Optional<NewsletterReaction> removeReaction(String code) {
        return Optional.ofNullable(this.reactions.remove(code));
    }

    public void incrementReaction(String code, boolean fromMe) {
        this.findReaction(code).ifPresentOrElse(reaction -> {
            reaction.setCount(reaction.count() + 1L);
            reaction.setFromMe(fromMe);
        }, () -> {
            NewsletterReaction reaction = new NewsletterReaction(code, 1L, fromMe);
            this.addReaction(reaction);
        });
    }

    public void decrementReaction(String code) {
        this.findReaction(code).ifPresent(reaction -> {
            if (reaction.count() <= 1L) {
                this.removeReaction(reaction.content());
                return;
            }
            reaction.setCount(reaction.count() - 1L);
            reaction.setFromMe(false);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof NewsletterMessageInfo)) return false;
        NewsletterMessageInfo that = (NewsletterMessageInfo)obj;
        if (!Objects.equals(this.id(), that.id())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

